#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Jydge
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250910.1

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='jydge'
GAME_NAME='JYDGE'

ARCHIVE_BASE_0_NAME='JYDGE'
ARCHIVE_BASE_0_MD5='3b8c8a14b7d7bc7c059c479910eb449d'
ARCHIVE_BASE_0_TYPE='zip'
ARCHIVE_BASE_0_SIZE='310000'
ARCHIVE_BASE_0_VERSION='1.2.0.6-humble1'
ARCHIVE_BASE_0_URL='https://www.humblebundle.com/store/jydge'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_BIN_FILES='
JYDGE'
CONTENT_GAME_DATA_FILES='
*.pak
*.xml'

APP_MAIN_EXE='JYDGE'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libgcc_s.so.1
libm.so.6
libopenal.so.1
libpthread.so.0
libSDL2-2.0.so.0
libstdc++.so.6'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default

# Include game data.

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers.

launchers_generation

# Build packages.

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
