"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Style = exports.CliHelpShower = void 0;
const style_1 = require("./style");
// From strip-ansi
const AnsiPattern = [
    "[\\u001B\\u009B][[\\]()#;?]*(?:(?:(?:[a-zA-Z\\d]*(?:;[-a-zA-Z\\d\\/#&.:=?%@~_]*)*)?\\u0007)",
    "(?:(?:\\d{1,4}(?:;\\d{0,4})*)?[\\dA-PR-TZcf-ntqry=><~]))"
].join("|");
const AnsiRegex = new RegExp(AnsiPattern, "g");
class CliHelpShower {
    constructor(indentPrefix = "", bulletPrefix = "", hangingIndentPrefix = "") {
        this.indentPrefix = indentPrefix;
        this.bulletPrefix = bulletPrefix;
        this.hangingIndentPrefix = hangingIndentPrefix;
    }
    indent(bullet = "") {
        return new CliHelpShower(this.indentPrefix + "  ", bullet, this.hangingIndentPrefix);
    }
    withIndent(bullet, fn) {
        fn(this.indent(bullet));
        return this;
    }
    hangingIndent(s = "  ") {
        return new CliHelpShower(this.indentPrefix, this.bulletPrefix, this.hangingIndentPrefix + s);
    }
    message(...text) {
        const words = text
            .filter(t => !!t)
            .map(t => (t ? t.split(" ") : []))
            .reduce((a, b) => [...a, ...b], []);
        this.messageImpl(words);
        return this;
    }
    messageImpl(words) {
        const prefixFirstLine = this.indentPrefix + this.bulletPrefix;
        const prefixContinueLine = " ".repeat(prefixFirstLine.length) + this.hangingIndentPrefix;
        let availableWidth = style_1.CONSOLE_WIDTH - prefixFirstLine.length;
        let c = 0, line = "";
        process.stderr.write(prefixFirstLine);
        for (const word of words) {
            const wordColumns = this.measureColumns(word);
            if (!line) {
                line += word;
                c = wordColumns;
            }
            else if (c + 1 + wordColumns < availableWidth) {
                line += " " + word;
                c += 1 + wordColumns;
            }
            else {
                process.stderr.write(line + "\n" + prefixContinueLine);
                availableWidth = style_1.CONSOLE_WIDTH - prefixContinueLine.length;
                line = word;
                c = wordColumns;
            }
        }
        if (line)
            process.stderr.write(line);
        process.stderr.write("\n");
    }
    measureColumns(word) {
        return word.replace(AnsiRegex, "").length;
    }
}
exports.CliHelpShower = CliHelpShower;
exports.Style = require("./style");
//# sourceMappingURL=index.js.map