% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doRNG.R
\name{registerDoRNG}
\alias{registerDoRNG}
\title{Registering doRNG for Persistent Reproducible Parallel Foreach Loops}
\usage{
registerDoRNG(seed = NULL, once = TRUE)
}
\arguments{
\item{seed}{a numerical seed to use (as a single or 6-length numerical value)}

\item{once}{a logical to indicate if the RNG sequence should be seeded at the 
beginning of each loop or only at the first loop.}
}
\value{
The value returned by [foreach::setDoPar]
}
\description{
\code{registerDoRNG} registers the doRNG foreach backend.
Subsequent `%dopar%` loops are then performed using the previously 
registered foreach backend, but are internally performed as [%dorng%] loops,
making them fully reproducible.
}
\details{
Briefly, the RNG is set, before each iteration, with seeds for L'Ecuyer's CMRG 
that overall generate a reproducible sequence of statistically independent 
random streams.

Note that (re-)registering a foreach backend other than doRNG, after a call 
to \code{registerDoRNG} disables doRNG -- which then needs to be registered.
}
\examples{

if (requireNamespace("doParallel", quietly = TRUE)) {
  cl <- parallel::makeCluster(2)
  doParallel::registerDoParallel(cl)

  tryCatch({
    # One can make reproducible loops using the \%dorng\% operator
    r1 <- foreach(i=1:4, .options.RNG=1234) \%dorng\% { runif(1) }

    # or convert \%dopar\% loops using registerDoRNG
    registerDoRNG(1234)
    r2 <- foreach(i=1:4) \%dopar\% { runif(1) }
    identical(r1, r2)

    # Registering another foreach backend disables doRNG
    doParallel::registerDoParallel(cl)
    set.seed(1234)
    s1 <- foreach(i=1:4) \%dopar\% { runif(1) }
    set.seed(1234)
    s2 <- foreach(i=1:4) \%dopar\% { runif(1) }
    identical(s1, s2)
    \dontshow{ stopifnot(!identical(s1, s2)) }

    # doRNG is re-enabled by re-registering it
    registerDoRNG()
    set.seed(1234)
    r3 <- foreach(i=1:4) \%dopar\% { runif(1) }
    identical(r2, r3)

    # argument `once=FALSE` reseeds doRNG's seed at the beginning of each loop
    registerDoRNG(1234, once=FALSE)
    a1 <- foreach(i=1:4) \%dopar\% { runif(1) }
    a2 <- foreach(i=1:4) \%dopar\% { runif(1) }
    identical(a1, a2)

    # Once doRNG is registered the seed can also be passed as an option to \%dopar\%
    b1 <- foreach(i=1:4, .options.RNG=456) \%dopar\% { runif(1) }
    b2 <- foreach(i=1:4, .options.RNG=456) \%dopar\% { runif(1) }
    identical(b1, b2) && !identical(b1, r1)
    \dontshow{ stopifnot(identical(b1, b2) && !identical(b1, r1)) }
  }, finally = {
    foreach::registerDoSEQ()
    parallel::stopCluster(cl)
  })
} else {
  message("Package 'doParallel' is not installed; skipping this example.")
}
}
\seealso{
[%dorng%]
}
