/**
 * \file pappsomspp/processing/cbor/psm/evalscan/psmspecglob.h
 * \date 19/07/2025
 * \author Olivier Langella
 * \brief compute specglob alignment on scan's PSM
 */

/*******************************************************************************
 * Copyright (c) 2025 Olivier Langella <Olivier.Langella@universite-paris-saclay.fr>.
 *
 * This file is part of PAPPSOms-tools.
 *
 *     PAPPSOms-tools is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms-tools is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms-tools.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/
#pragma once

#include "pappsomspp/core/processing/cbor/psm/psmfilescanprocessandcopy.h"
#include "pappsomspp/core/protein/protein.h"
#include "pappsomspp/core/amino_acid/aacode.h"
#include "pappsomspp/core/processing/specpeptidoms/scorevalues.h"
#include "pappsomspp/core/processing/specpeptidoms/semiglobalalignment.h"
#include <QJsonObject>

namespace pappso
{
namespace cbor
{
namespace psm
{

class PsmSpecPeptidOmsScan;
/**
 * @todo write docs
 */
class PsmSpecPeptidOms : public PsmFileScanProcessAndCopy
{
  friend PsmSpecPeptidOmsScan;

  public:
  /**
   * Default constructor
   */
  PsmSpecPeptidOms(std::size_t buffer_scan_size,
                   CborStreamWriter *cbor_output_p,
                   const QJsonObject &parameters);

  /**
   * Destructor
   */
  virtual ~PsmSpecPeptidOms();


  void filterMassSpectrum(pappso::MassSpectrum &mass_spectrum) const;

  const pappso::AaCode &getAaCode() const;

  protected:
  CborScanMapBase *newCborScanMap() override;

  void parameterMapReady(pappso::UiMonitorInterface &monitor) override;


  virtual void processBufferScanDone(pappso::UiMonitorInterface &monitor) override;


  virtual void proteinMapReady(pappso::UiMonitorInterface &monitor) override;


  protected:
  pappso::AaCode m_aaCode;
  QJsonObject m_specpeptidomsParameters;
  pappso::PrecisionPtr m_fragmentTolerance;
  double m_minimumMz;
  std::size_t m_nMostIntense;
  bool m_deisotope = true;
  pappso::specpeptidoms::ScoreValues m_scoreValues;


  std::size_t m_countScanProcessed = 0;
  pappso::cbor::psm::PsmProteinMap m_newProteinMap;
  QString m_decoyPrefix;
  std::size_t m_maxInterpretationsPerSpectrum = 1;
};


class PsmSpecPeptidOmsScan : public CborScanMapBase
{
  public:
  /**
   * Default constructor
   */
  PsmSpecPeptidOmsScan(const PsmSpecPeptidOms &psm_specpeptidoms,
                       pappso::PrecisionPtr fragment_tolerance);

  /**
   * Destructor
   */
  virtual ~PsmSpecPeptidOmsScan();

  virtual void filterAndSortPsmList() override;

  protected:
  void process() override;

  void sequenceAlignment(bool is_reverse,
                         const QCborMap &old_cbor_psm_map,
                         QCborArray &new_psm_arr,
                         pappso::specpeptidoms::SpOMSSpectrumCsp &experimental_spectrum,
                         pappso::specpeptidoms::SemiGlobalAlignment &semi_global_alignment,
                         const pappso::specpeptidoms::SpOMSProtein *protein_ptr);

  void storeAlignment(bool is_reverse,
                      const QCborMap &old_cbor_psm,
                      QCborMap &new_cbor_psm,
                      const QString &accession,
                      const pappso::specpeptidoms::Alignment &alignment);

  void fixPositionStart(bool is_reverse, QCborMap &new_cbor_psm, std::size_t offset_position) const;


  private:
  const PsmSpecPeptidOms *mp_psmSpecPeptidOms;
  QString m_decoyPrefix;
};
} // namespace psm
} // namespace cbor
} // namespace pappso
