/**
 * Pixels test suite
 */
#include <SDL3/SDL.h>
#include <SDL3/SDL_test.h>
#include "testautomation_suites.h"

/* Test case functions */

/* Definition of all RGB formats used to test pixel conversions */
static const SDL_PixelFormat g_AllFormats[] = {
    SDL_PIXELFORMAT_INDEX1LSB,
    SDL_PIXELFORMAT_INDEX1MSB,
    SDL_PIXELFORMAT_INDEX2LSB,
    SDL_PIXELFORMAT_INDEX2MSB,
    SDL_PIXELFORMAT_INDEX4LSB,
    SDL_PIXELFORMAT_INDEX4MSB,
    SDL_PIXELFORMAT_INDEX8,
    SDL_PIXELFORMAT_RGB332,
    SDL_PIXELFORMAT_XRGB4444,
    SDL_PIXELFORMAT_XBGR4444,
    SDL_PIXELFORMAT_XRGB1555,
    SDL_PIXELFORMAT_XBGR1555,
    SDL_PIXELFORMAT_ARGB4444,
    SDL_PIXELFORMAT_RGBA4444,
    SDL_PIXELFORMAT_ABGR4444,
    SDL_PIXELFORMAT_BGRA4444,
    SDL_PIXELFORMAT_ARGB1555,
    SDL_PIXELFORMAT_RGBA5551,
    SDL_PIXELFORMAT_ABGR1555,
    SDL_PIXELFORMAT_BGRA5551,
    SDL_PIXELFORMAT_RGB565,
    SDL_PIXELFORMAT_BGR565,
    SDL_PIXELFORMAT_RGB24,
    SDL_PIXELFORMAT_BGR24,
    SDL_PIXELFORMAT_XRGB8888,
    SDL_PIXELFORMAT_RGBX8888,
    SDL_PIXELFORMAT_XBGR8888,
    SDL_PIXELFORMAT_BGRX8888,
    SDL_PIXELFORMAT_ARGB8888,
    SDL_PIXELFORMAT_RGBA8888,
    SDL_PIXELFORMAT_ABGR8888,
    SDL_PIXELFORMAT_BGRA8888,
    SDL_PIXELFORMAT_XRGB2101010,
    SDL_PIXELFORMAT_XBGR2101010,
    SDL_PIXELFORMAT_ARGB2101010,
    SDL_PIXELFORMAT_ABGR2101010,
    SDL_PIXELFORMAT_YV12,
    SDL_PIXELFORMAT_IYUV,
    SDL_PIXELFORMAT_YUY2,
    SDL_PIXELFORMAT_UYVY,
    SDL_PIXELFORMAT_YVYU,
    SDL_PIXELFORMAT_NV12,
    SDL_PIXELFORMAT_NV21
};
static const int g_numAllFormats = SDL_arraysize(g_AllFormats);

static const char *g_AllFormatsVerbose[] = {
    "SDL_PIXELFORMAT_INDEX1LSB",
    "SDL_PIXELFORMAT_INDEX1MSB",
    "SDL_PIXELFORMAT_INDEX2LSB",
    "SDL_PIXELFORMAT_INDEX2MSB",
    "SDL_PIXELFORMAT_INDEX4LSB",
    "SDL_PIXELFORMAT_INDEX4MSB",
    "SDL_PIXELFORMAT_INDEX8",
    "SDL_PIXELFORMAT_RGB332",
    "SDL_PIXELFORMAT_XRGB4444",
    "SDL_PIXELFORMAT_XBGR4444",
    "SDL_PIXELFORMAT_XRGB1555",
    "SDL_PIXELFORMAT_XBGR1555",
    "SDL_PIXELFORMAT_ARGB4444",
    "SDL_PIXELFORMAT_RGBA4444",
    "SDL_PIXELFORMAT_ABGR4444",
    "SDL_PIXELFORMAT_BGRA4444",
    "SDL_PIXELFORMAT_ARGB1555",
    "SDL_PIXELFORMAT_RGBA5551",
    "SDL_PIXELFORMAT_ABGR1555",
    "SDL_PIXELFORMAT_BGRA5551",
    "SDL_PIXELFORMAT_RGB565",
    "SDL_PIXELFORMAT_BGR565",
    "SDL_PIXELFORMAT_RGB24",
    "SDL_PIXELFORMAT_BGR24",
    "SDL_PIXELFORMAT_XRGB8888",
    "SDL_PIXELFORMAT_RGBX8888",
    "SDL_PIXELFORMAT_XBGR8888",
    "SDL_PIXELFORMAT_BGRX8888",
    "SDL_PIXELFORMAT_ARGB8888",
    "SDL_PIXELFORMAT_RGBA8888",
    "SDL_PIXELFORMAT_ABGR8888",
    "SDL_PIXELFORMAT_BGRA8888",
    "SDL_PIXELFORMAT_XRGB2101010",
    "SDL_PIXELFORMAT_XBGR2101010",
    "SDL_PIXELFORMAT_ARGB2101010",
    "SDL_PIXELFORMAT_ABGR2101010",
    "SDL_PIXELFORMAT_YV12",
    "SDL_PIXELFORMAT_IYUV",
    "SDL_PIXELFORMAT_YUY2",
    "SDL_PIXELFORMAT_UYVY",
    "SDL_PIXELFORMAT_YVYU",
    "SDL_PIXELFORMAT_NV12",
    "SDL_PIXELFORMAT_NV21"
};

static const SDL_PixelFormat g_AllLargeFormats[] = {
    SDL_PIXELFORMAT_RGB48,
    SDL_PIXELFORMAT_BGR48,
    SDL_PIXELFORMAT_RGBA64,
    SDL_PIXELFORMAT_ARGB64,
    SDL_PIXELFORMAT_BGRA64,
    SDL_PIXELFORMAT_ABGR64,
    SDL_PIXELFORMAT_RGB48_FLOAT,
    SDL_PIXELFORMAT_BGR48_FLOAT,
    SDL_PIXELFORMAT_RGBA64_FLOAT,
    SDL_PIXELFORMAT_ARGB64_FLOAT,
    SDL_PIXELFORMAT_BGRA64_FLOAT,
    SDL_PIXELFORMAT_ABGR64_FLOAT,
    SDL_PIXELFORMAT_RGB96_FLOAT,
    SDL_PIXELFORMAT_BGR96_FLOAT,
    SDL_PIXELFORMAT_RGBA128_FLOAT,
    SDL_PIXELFORMAT_ARGB128_FLOAT,
    SDL_PIXELFORMAT_BGRA128_FLOAT,
    SDL_PIXELFORMAT_ABGR128_FLOAT
};

/* Definition of some invalid formats for negative tests */
static Uint32 g_invalidPixelFormats[] = {
    SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED32, SDL_PACKEDORDER_ABGR, SDL_PACKEDLAYOUT_1010102 + 1, 32, 4),
    SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED32, SDL_PACKEDORDER_ABGR, SDL_PACKEDLAYOUT_1010102 + 2, 32, 4)
};
static const int g_numInvalidPixelFormats = SDL_arraysize(g_invalidPixelFormats);
static const char *g_invalidPixelFormatsVerbose[] = {
    "SDL_PIXELFORMAT_UNKNOWN",
    "SDL_PIXELFORMAT_UNKNOWN"
};

/* Verify the pixel formats are laid out as expected */
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_INDEX1LSB_FORMAT, SDL_PIXELFORMAT_INDEX1LSB == SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_INDEX1, SDL_BITMAPORDER_4321, 0, 1, 0));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_INDEX1LSB_FOURCC, !SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_INDEX1LSB));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_INDEX1LSB_INDEXED, SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_INDEX1LSB));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_INDEX1LSB_PACKED, !SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_INDEX1LSB));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_INDEX1LSB_ARRAY, !SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_INDEX1LSB));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_INDEX1LSB_10BIT, !SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_INDEX1LSB));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_INDEX1LSB_FLOAT, !SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_INDEX1LSB));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_INDEX1LSB_ALPHA, !SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_INDEX1LSB));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_INDEX1MSB_FORMAT, SDL_PIXELFORMAT_INDEX1MSB == SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_INDEX1, SDL_BITMAPORDER_1234, 0, 1, 0));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_INDEX1MSB_FOURCC, !SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_INDEX1MSB));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_INDEX1MSB_INDEXED, SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_INDEX1MSB));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_INDEX1MSB_PACKED, !SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_INDEX1MSB));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_INDEX1MSB_ARRAY, !SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_INDEX1MSB));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_INDEX1MSB_10BIT, !SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_INDEX1MSB));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_INDEX1MSB_FLOAT, !SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_INDEX1MSB));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_INDEX1MSB_ALPHA, !SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_INDEX1MSB));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_INDEX2LSB_FORMAT, SDL_PIXELFORMAT_INDEX2LSB == SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_INDEX2, SDL_BITMAPORDER_4321, 0, 2, 0));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_INDEX2LSB_FOURCC, !SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_INDEX2LSB));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_INDEX2LSB_INDEXED, SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_INDEX2LSB));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_INDEX2LSB_PACKED, !SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_INDEX2LSB));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_INDEX2LSB_ARRAY, !SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_INDEX2LSB));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_INDEX2LSB_10BIT, !SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_INDEX2LSB));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_INDEX2LSB_FLOAT, !SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_INDEX2LSB));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_INDEX2LSB_ALPHA, !SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_INDEX2LSB));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_INDEX2MSB_FORMAT, SDL_PIXELFORMAT_INDEX2MSB == SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_INDEX2, SDL_BITMAPORDER_1234, 0, 2, 0));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_INDEX2MSB_FOURCC, !SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_INDEX2MSB));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_INDEX2MSB_INDEXED, SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_INDEX2MSB));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_INDEX2MSB_PACKED, !SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_INDEX2MSB));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_INDEX2MSB_ARRAY, !SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_INDEX2MSB));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_INDEX2MSB_10BIT, !SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_INDEX2MSB));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_INDEX2MSB_FLOAT, !SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_INDEX2MSB));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_INDEX2MSB_ALPHA, !SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_INDEX2MSB));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_INDEX4LSB_FORMAT, SDL_PIXELFORMAT_INDEX4LSB == SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_INDEX4, SDL_BITMAPORDER_4321, 0, 4, 0));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_INDEX4LSB_FOURCC, !SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_INDEX4LSB));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_INDEX4LSB_INDEXED, SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_INDEX4LSB));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_INDEX4LSB_PACKED, !SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_INDEX4LSB));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_INDEX4LSB_ARRAY, !SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_INDEX4LSB));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_INDEX4LSB_10BIT, !SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_INDEX4LSB));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_INDEX4LSB_FLOAT, !SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_INDEX4LSB));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_INDEX4LSB_ALPHA, !SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_INDEX4LSB));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_INDEX4MSB_FORMAT, SDL_PIXELFORMAT_INDEX4MSB == SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_INDEX4, SDL_BITMAPORDER_1234, 0, 4, 0));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_INDEX4MSB_FOURCC, !SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_INDEX4MSB));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_INDEX4MSB_INDEXED, SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_INDEX4MSB));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_INDEX4MSB_PACKED, !SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_INDEX4MSB));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_INDEX4MSB_ARRAY, !SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_INDEX4MSB));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_INDEX4MSB_10BIT, !SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_INDEX4MSB));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_INDEX4MSB_FLOAT, !SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_INDEX4MSB));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_INDEX4MSB_ALPHA, !SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_INDEX4MSB));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_INDEX8_FORMAT, SDL_PIXELFORMAT_INDEX8 == SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_INDEX8, 0, 0, 8, 1));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_INDEX8_FOURCC, !SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_INDEX8));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_INDEX8_INDEXED, SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_INDEX8));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_INDEX8_PACKED, !SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_INDEX8));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_INDEX8_ARRAY, !SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_INDEX8));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_INDEX8_10BIT, !SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_INDEX8));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_INDEX8_FLOAT, !SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_INDEX8));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_INDEX8_ALPHA, !SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_INDEX8));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGB332_FORMAT, SDL_PIXELFORMAT_RGB332 == SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED8, SDL_PACKEDORDER_XRGB, SDL_PACKEDLAYOUT_332, 8, 1));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGB332_FOURCC, !SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_RGB332));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGB332_INDEXED, !SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_RGB332));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGB332_PACKED, SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_RGB332));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGB332_ARRAY, !SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_RGB332));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGB332_10BIT, !SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_RGB332));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGB332_FLOAT, !SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_RGB332));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGB332_ALPHA, !SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_RGB332));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XRGB4444_FORMAT, SDL_PIXELFORMAT_XRGB4444 == SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED16, SDL_PACKEDORDER_XRGB, SDL_PACKEDLAYOUT_4444, 12, 2));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XRGB4444_FOURCC, !SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_XRGB4444));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XRGB4444_INDEXED, !SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_XRGB4444));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XRGB4444_PACKED, SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_XRGB4444));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XRGB4444_ARRAY, !SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_XRGB4444));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XRGB4444_10BIT, !SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_XRGB4444));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XRGB4444_FLOAT, !SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_XRGB4444));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XRGB4444_ALPHA, !SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_XRGB4444));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XBGR4444_FORMAT, SDL_PIXELFORMAT_XBGR4444 == SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED16, SDL_PACKEDORDER_XBGR, SDL_PACKEDLAYOUT_4444, 12, 2));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XBGR4444_FOURCC, !SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_XBGR4444));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XBGR4444_INDEXED, !SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_XBGR4444));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XBGR4444_PACKED, SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_XBGR4444));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XBGR4444_ARRAY, !SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_XBGR4444));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XBGR4444_10BIT, !SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_XBGR4444));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XBGR4444_FLOAT, !SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_XBGR4444));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XBGR4444_ALPHA, !SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_XBGR4444));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XRGB1555_FORMAT, SDL_PIXELFORMAT_XRGB1555 == SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED16, SDL_PACKEDORDER_XRGB, SDL_PACKEDLAYOUT_1555, 15, 2));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XRGB1555_FOURCC, !SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_XRGB1555));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XRGB1555_INDEXED, !SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_XRGB1555));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XRGB1555_PACKED, SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_XRGB1555));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XRGB1555_ARRAY, !SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_XRGB1555));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XRGB1555_10BIT, !SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_XRGB1555));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XRGB1555_FLOAT, !SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_XRGB1555));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XRGB1555_ALPHA, !SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_XRGB1555));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XBGR1555_FORMAT, SDL_PIXELFORMAT_XBGR1555 == SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED16, SDL_PACKEDORDER_XBGR, SDL_PACKEDLAYOUT_1555, 15, 2));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XBGR1555_FOURCC, !SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_XBGR1555));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XBGR1555_INDEXED, !SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_XBGR1555));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XBGR1555_PACKED, SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_XBGR1555));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XBGR1555_ARRAY, !SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_XBGR1555));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XBGR1555_10BIT, !SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_XBGR1555));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XBGR1555_FLOAT, !SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_XBGR1555));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XBGR1555_ALPHA, !SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_XBGR1555));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ARGB4444_FORMAT, SDL_PIXELFORMAT_ARGB4444 == SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED16, SDL_PACKEDORDER_ARGB, SDL_PACKEDLAYOUT_4444, 16, 2));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ARGB4444_FOURCC, !SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_ARGB4444));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ARGB4444_INDEXED, !SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_ARGB4444));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ARGB4444_PACKED, SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_ARGB4444));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ARGB4444_ARRAY, !SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_ARGB4444));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ARGB4444_10BIT, !SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_ARGB4444));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ARGB4444_FLOAT, !SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_ARGB4444));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ARGB4444_ALPHA, SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_ARGB4444));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGBA4444_FORMAT, SDL_PIXELFORMAT_RGBA4444 == SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED16, SDL_PACKEDORDER_RGBA, SDL_PACKEDLAYOUT_4444, 16, 2));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGBA4444_FOURCC, !SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_RGBA4444));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGBA4444_INDEXED, !SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_RGBA4444));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGBA4444_PACKED, SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_RGBA4444));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGBA4444_ARRAY, !SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_RGBA4444));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGBA4444_10BIT, !SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_RGBA4444));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGBA4444_FLOAT, !SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_RGBA4444));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGBA4444_ALPHA, SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_RGBA4444));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ABGR4444_FORMAT, SDL_PIXELFORMAT_ABGR4444 == SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED16, SDL_PACKEDORDER_ABGR, SDL_PACKEDLAYOUT_4444, 16, 2));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ABGR4444_FOURCC, !SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_ABGR4444));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ABGR4444_INDEXED, !SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_ABGR4444));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ABGR4444_PACKED, SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_ABGR4444));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ABGR4444_ARRAY, !SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_ABGR4444));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ABGR4444_10BIT, !SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_ABGR4444));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ABGR4444_FLOAT, !SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_ABGR4444));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ABGR4444_ALPHA, SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_ABGR4444));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGRA4444_FORMAT, SDL_PIXELFORMAT_BGRA4444 == SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED16, SDL_PACKEDORDER_BGRA, SDL_PACKEDLAYOUT_4444, 16, 2));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGRA4444_FOURCC, !SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_BGRA4444));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGRA4444_INDEXED, !SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_BGRA4444));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGRA4444_PACKED, SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_BGRA4444));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGRA4444_ARRAY, !SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_BGRA4444));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGRA4444_10BIT, !SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_BGRA4444));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGRA4444_FLOAT, !SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_BGRA4444));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGRA4444_ALPHA, SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_BGRA4444));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ARGB1555_FORMAT, SDL_PIXELFORMAT_ARGB1555 == SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED16, SDL_PACKEDORDER_ARGB, SDL_PACKEDLAYOUT_1555, 16, 2));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ARGB1555_FOURCC, !SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_ARGB1555));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ARGB1555_INDEXED, !SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_ARGB1555));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ARGB1555_PACKED, SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_ARGB1555));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ARGB1555_ARRAY, !SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_ARGB1555));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ARGB1555_10BIT, !SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_ARGB1555));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ARGB1555_FLOAT, !SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_ARGB1555));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ARGB1555_ALPHA, SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_ARGB1555));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGBA5551_FORMAT, SDL_PIXELFORMAT_RGBA5551 == SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED16, SDL_PACKEDORDER_RGBA, SDL_PACKEDLAYOUT_5551, 16, 2));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGBA5551_FOURCC, !SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_RGBA5551));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGBA5551_INDEXED, !SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_RGBA5551));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGBA5551_PACKED, SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_RGBA5551));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGBA5551_ARRAY, !SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_RGBA5551));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGBA5551_10BIT, !SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_RGBA5551));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGBA5551_FLOAT, !SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_RGBA5551));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGBA5551_ALPHA, SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_RGBA5551));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ABGR1555_FORMAT, SDL_PIXELFORMAT_ABGR1555 == SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED16, SDL_PACKEDORDER_ABGR, SDL_PACKEDLAYOUT_1555, 16, 2));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ABGR1555_FOURCC, !SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_ABGR1555));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ABGR1555_INDEXED, !SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_ABGR1555));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ABGR1555_PACKED, SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_ABGR1555));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ABGR1555_ARRAY, !SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_ABGR1555));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ABGR1555_10BIT, !SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_ABGR1555));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ABGR1555_FLOAT, !SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_ABGR1555));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ABGR1555_ALPHA, SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_ABGR1555));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGRA5551_FORMAT, SDL_PIXELFORMAT_BGRA5551 == SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED16, SDL_PACKEDORDER_BGRA, SDL_PACKEDLAYOUT_5551, 16, 2));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGRA5551_FOURCC, !SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_BGRA5551));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGRA5551_INDEXED, !SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_BGRA5551));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGRA5551_PACKED, SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_BGRA5551));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGRA5551_ARRAY, !SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_BGRA5551));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGRA5551_10BIT, !SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_BGRA5551));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGRA5551_FLOAT, !SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_BGRA5551));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGRA5551_ALPHA, SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_BGRA5551));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGB565_FORMAT, SDL_PIXELFORMAT_RGB565 == SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED16, SDL_PACKEDORDER_XRGB, SDL_PACKEDLAYOUT_565, 16, 2));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGB565_FOURCC, !SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_RGB565));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGB565_INDEXED, !SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_RGB565));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGB565_PACKED, SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_RGB565));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGB565_ARRAY, !SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_RGB565));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGB565_10BIT, !SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_RGB565));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGB565_FLOAT, !SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_RGB565));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGB565_ALPHA, !SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_RGB565));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGR565_FORMAT, SDL_PIXELFORMAT_BGR565 == SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED16, SDL_PACKEDORDER_XBGR, SDL_PACKEDLAYOUT_565, 16, 2));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGR565_FOURCC, !SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_BGR565));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGR565_INDEXED, !SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_BGR565));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGR565_PACKED, SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_BGR565));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGR565_ARRAY, !SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_BGR565));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGR565_10BIT, !SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_BGR565));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGR565_FLOAT, !SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_BGR565));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGR565_ALPHA, !SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_BGR565));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGB24_FORMAT, SDL_PIXELFORMAT_RGB24 == SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_ARRAYU8, SDL_ARRAYORDER_RGB, 0, 24, 3));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGB24_FOURCC, !SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_RGB24));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGB24_INDEXED, !SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_RGB24));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGB24_PACKED, !SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_RGB24));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGB24_ARRAY, SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_RGB24));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGB24_10BIT, !SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_RGB24));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGB24_FLOAT, !SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_RGB24));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGB24_ALPHA, !SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_RGB24));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGR24_FORMAT, SDL_PIXELFORMAT_BGR24 == SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_ARRAYU8, SDL_ARRAYORDER_BGR, 0, 24, 3));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGR24_FOURCC, !SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_BGR24));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGR24_INDEXED, !SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_BGR24));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGR24_PACKED, !SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_BGR24));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGR24_ARRAY, SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_BGR24));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGR24_10BIT, !SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_BGR24));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGR24_FLOAT, !SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_BGR24));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGR24_ALPHA, !SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_BGR24));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XRGB8888_FORMAT, SDL_PIXELFORMAT_XRGB8888 == SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED32, SDL_PACKEDORDER_XRGB, SDL_PACKEDLAYOUT_8888, 24, 4));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XRGB8888_FOURCC, !SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_XRGB8888));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XRGB8888_INDEXED, !SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_XRGB8888));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XRGB8888_PACKED, SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_XRGB8888));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XRGB8888_ARRAY, !SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_XRGB8888));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XRGB8888_10BIT, !SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_XRGB8888));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XRGB8888_FLOAT, !SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_XRGB8888));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XRGB8888_ALPHA, !SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_XRGB8888));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGBX8888_FORMAT, SDL_PIXELFORMAT_RGBX8888 == SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED32, SDL_PACKEDORDER_RGBX, SDL_PACKEDLAYOUT_8888, 24, 4));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGBX8888_FOURCC, !SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_RGBX8888));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGBX8888_INDEXED, !SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_RGBX8888));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGBX8888_PACKED, SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_RGBX8888));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGBX8888_ARRAY, !SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_RGBX8888));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGBX8888_10BIT, !SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_RGBX8888));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGBX8888_FLOAT, !SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_RGBX8888));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGBX8888_ALPHA, !SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_RGBX8888));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XBGR8888_FORMAT, SDL_PIXELFORMAT_XBGR8888 == SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED32, SDL_PACKEDORDER_XBGR, SDL_PACKEDLAYOUT_8888, 24, 4));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XBGR8888_FOURCC, !SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_XBGR8888));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XBGR8888_INDEXED, !SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_XBGR8888));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XBGR8888_PACKED, SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_XBGR8888));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XBGR8888_ARRAY, !SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_XBGR8888));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XBGR8888_10BIT, !SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_XBGR8888));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XBGR8888_FLOAT, !SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_XBGR8888));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XBGR8888_ALPHA, !SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_XBGR8888));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGRX8888_FORMAT, SDL_PIXELFORMAT_BGRX8888 == SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED32, SDL_PACKEDORDER_BGRX, SDL_PACKEDLAYOUT_8888, 24, 4));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGRX8888_FOURCC, !SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_BGRX8888));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGRX8888_INDEXED, !SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_BGRX8888));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGRX8888_PACKED, SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_BGRX8888));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGRX8888_ARRAY, !SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_BGRX8888));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGRX8888_10BIT, !SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_BGRX8888));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGRX8888_FLOAT, !SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_BGRX8888));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGRX8888_ALPHA, !SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_BGRX8888));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ARGB8888_FORMAT, SDL_PIXELFORMAT_ARGB8888 == SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED32, SDL_PACKEDORDER_ARGB, SDL_PACKEDLAYOUT_8888, 32, 4));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ARGB8888_FOURCC, !SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_ARGB8888));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ARGB8888_INDEXED, !SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_ARGB8888));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ARGB8888_PACKED, SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_ARGB8888));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ARGB8888_ARRAY, !SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_ARGB8888));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ARGB8888_10BIT, !SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_ARGB8888));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ARGB8888_FLOAT, !SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_ARGB8888));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ARGB8888_ALPHA, SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_ARGB8888));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGBA8888_FORMAT, SDL_PIXELFORMAT_RGBA8888 == SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED32, SDL_PACKEDORDER_RGBA, SDL_PACKEDLAYOUT_8888, 32, 4));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGBA8888_FOURCC, !SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_RGBA8888));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGBA8888_INDEXED, !SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_RGBA8888));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGBA8888_PACKED, SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_RGBA8888));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGBA8888_ARRAY, !SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_RGBA8888));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGBA8888_10BIT, !SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_RGBA8888));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGBA8888_FLOAT, !SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_RGBA8888));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGBA8888_ALPHA, SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_RGBA8888));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ABGR8888_FORMAT, SDL_PIXELFORMAT_ABGR8888 == SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED32, SDL_PACKEDORDER_ABGR, SDL_PACKEDLAYOUT_8888, 32, 4));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ABGR8888_FOURCC, !SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_ABGR8888));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ABGR8888_INDEXED, !SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_ABGR8888));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ABGR8888_PACKED, SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_ABGR8888));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ABGR8888_ARRAY, !SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_ABGR8888));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ABGR8888_10BIT, !SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_ABGR8888));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ABGR8888_FLOAT, !SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_ABGR8888));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ABGR8888_ALPHA, SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_ABGR8888));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGRA8888_FORMAT, SDL_PIXELFORMAT_BGRA8888 == SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED32, SDL_PACKEDORDER_BGRA, SDL_PACKEDLAYOUT_8888, 32, 4));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGRA8888_FOURCC, !SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_BGRA8888));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGRA8888_INDEXED, !SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_BGRA8888));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGRA8888_PACKED, SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_BGRA8888));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGRA8888_ARRAY, !SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_BGRA8888));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGRA8888_10BIT, !SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_BGRA8888));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGRA8888_FLOAT, !SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_BGRA8888));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGRA8888_ALPHA, SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_BGRA8888));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XRGB2101010_FORMAT, SDL_PIXELFORMAT_XRGB2101010 == SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED32, SDL_PACKEDORDER_XRGB, SDL_PACKEDLAYOUT_2101010, 32, 4));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XRGB2101010_FOURCC, !SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_XRGB2101010));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XRGB2101010_INDEXED, !SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_XRGB2101010));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XRGB2101010_PACKED, SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_XRGB2101010));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XRGB2101010_ARRAY, !SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_XRGB2101010));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XRGB2101010_10BIT, SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_XRGB2101010));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XRGB2101010_FLOAT, !SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_XRGB2101010));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XRGB2101010_ALPHA, !SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_XRGB2101010));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XBGR2101010_FORMAT, SDL_PIXELFORMAT_XBGR2101010 == SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED32, SDL_PACKEDORDER_XBGR, SDL_PACKEDLAYOUT_2101010, 32, 4));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XBGR2101010_FOURCC, !SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_XBGR2101010));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XBGR2101010_INDEXED, !SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_XBGR2101010));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XBGR2101010_PACKED, SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_XBGR2101010));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XBGR2101010_ARRAY, !SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_XBGR2101010));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XBGR2101010_10BIT, SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_XBGR2101010));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XBGR2101010_FLOAT, !SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_XBGR2101010));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_XBGR2101010_ALPHA, !SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_XBGR2101010));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ARGB2101010_FORMAT, SDL_PIXELFORMAT_ARGB2101010 == SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED32, SDL_PACKEDORDER_ARGB, SDL_PACKEDLAYOUT_2101010, 32, 4));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ARGB2101010_FOURCC, !SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_ARGB2101010));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ARGB2101010_INDEXED, !SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_ARGB2101010));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ARGB2101010_PACKED, SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_ARGB2101010));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ARGB2101010_ARRAY, !SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_ARGB2101010));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ARGB2101010_10BIT, SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_ARGB2101010));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ARGB2101010_FLOAT, !SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_ARGB2101010));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ARGB2101010_ALPHA, SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_ARGB2101010));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ABGR2101010_FORMAT, SDL_PIXELFORMAT_ABGR2101010 == SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED32, SDL_PACKEDORDER_ABGR, SDL_PACKEDLAYOUT_2101010, 32, 4));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ABGR2101010_FOURCC, !SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_ABGR2101010));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ABGR2101010_INDEXED, !SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_ABGR2101010));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ABGR2101010_PACKED, SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_ABGR2101010));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ABGR2101010_ARRAY, !SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_ABGR2101010));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ABGR2101010_10BIT, SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_ABGR2101010));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ABGR2101010_FLOAT, !SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_ABGR2101010));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ABGR2101010_ALPHA, SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_ABGR2101010));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGB48_FORMAT, SDL_PIXELFORMAT_RGB48 == SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_ARRAYU16, SDL_ARRAYORDER_RGB, 0, 48, 6));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGB48_FOURCC, !SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_RGB48));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGB48_INDEXED, !SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_RGB48));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGB48_PACKED, !SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_RGB48));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGB48_ARRAY, SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_RGB48));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGB48_10BIT, !SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_RGB48));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGB48_FLOAT, !SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_RGB48));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGB48_ALPHA, !SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_RGB48));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGR48_FORMAT, SDL_PIXELFORMAT_BGR48 == SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_ARRAYU16, SDL_ARRAYORDER_BGR, 0, 48, 6));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGR48_FOURCC, !SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_BGR48));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGR48_INDEXED, !SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_BGR48));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGR48_PACKED, !SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_BGR48));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGR48_ARRAY, SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_BGR48));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGR48_10BIT, !SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_BGR48));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGR48_FLOAT, !SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_BGR48));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGR48_ALPHA, !SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_BGR48));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGBA64_FORMAT, SDL_PIXELFORMAT_RGBA64 == SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_ARRAYU16, SDL_ARRAYORDER_RGBA, 0, 64, 8));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGBA64_FOURCC, !SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_RGBA64));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGBA64_INDEXED, !SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_RGBA64));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGBA64_PACKED, !SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_RGBA64));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGBA64_ARRAY, SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_RGBA64));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGBA64_10BIT, !SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_RGBA64));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGBA64_FLOAT, !SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_RGBA64));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGBA64_ALPHA, SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_RGBA64));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ARGB64_FORMAT, SDL_PIXELFORMAT_ARGB64 == SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_ARRAYU16, SDL_ARRAYORDER_ARGB, 0, 64, 8));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ARGB64_FOURCC, !SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_ARGB64));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ARGB64_INDEXED, !SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_ARGB64));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ARGB64_PACKED, !SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_ARGB64));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ARGB64_ARRAY, SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_ARGB64));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ARGB64_10BIT, !SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_ARGB64));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ARGB64_FLOAT, !SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_ARGB64));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ARGB64_ALPHA, SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_ARGB64));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGRA64_FORMAT, SDL_PIXELFORMAT_BGRA64 == SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_ARRAYU16, SDL_ARRAYORDER_BGRA, 0, 64, 8));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGRA64_FOURCC, !SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_BGRA64));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGRA64_INDEXED, !SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_BGRA64));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGRA64_PACKED, !SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_BGRA64));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGRA64_ARRAY, SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_BGRA64));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGRA64_10BIT, !SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_BGRA64));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGRA64_FLOAT, !SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_BGRA64));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGRA64_ALPHA, SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_BGRA64));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ABGR64_FORMAT, SDL_PIXELFORMAT_ABGR64 == SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_ARRAYU16, SDL_ARRAYORDER_ABGR, 0, 64, 8));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ABGR64_FOURCC, !SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_ABGR64));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ABGR64_INDEXED, !SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_ABGR64));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ABGR64_PACKED, !SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_ABGR64));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ABGR64_ARRAY, SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_ABGR64));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ABGR64_10BIT, !SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_ABGR64));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ABGR64_FLOAT, !SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_ABGR64));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ABGR64_ALPHA, SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_ABGR64));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGB48_FLOAT_FORMAT, SDL_PIXELFORMAT_RGB48_FLOAT == SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_ARRAYF16, SDL_ARRAYORDER_RGB, 0, 48, 6));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGB48_FLOAT_FOURCC, !SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_RGB48_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGB48_FLOAT_INDEXED, !SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_RGB48_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGB48_FLOAT_PACKED, !SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_RGB48_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGB48_FLOAT_ARRAY, SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_RGB48_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGB48_FLOAT_10BIT, !SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_RGB48_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGB48_FLOAT_FLOAT, SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_RGB48_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGB48_FLOAT_ALPHA, !SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_RGB48_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGR48_FLOAT_FORMAT, SDL_PIXELFORMAT_BGR48_FLOAT == SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_ARRAYF16, SDL_ARRAYORDER_BGR, 0, 48, 6));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGR48_FLOAT_FOURCC, !SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_BGR48_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGR48_FLOAT_INDEXED, !SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_BGR48_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGR48_FLOAT_PACKED, !SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_BGR48_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGR48_FLOAT_ARRAY, SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_BGR48_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGR48_FLOAT_10BIT, !SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_BGR48_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGR48_FLOAT_FLOAT, SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_BGR48_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGR48_FLOAT_ALPHA, !SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_BGR48_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGBA64_FLOAT_FORMAT, SDL_PIXELFORMAT_RGBA64_FLOAT == SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_ARRAYF16, SDL_ARRAYORDER_RGBA, 0, 64, 8));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGBA64_FLOAT_FOURCC, !SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_RGBA64_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGBA64_FLOAT_INDEXED, !SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_RGBA64_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGBA64_FLOAT_PACKED, !SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_RGBA64_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGBA64_FLOAT_ARRAY, SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_RGBA64_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGBA64_FLOAT_10BIT, !SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_RGBA64_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGBA64_FLOAT_FLOAT, SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_RGBA64_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGBA64_FLOAT_ALPHA, SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_RGBA64_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ARGB64_FLOAT_FORMAT, SDL_PIXELFORMAT_ARGB64_FLOAT == SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_ARRAYF16, SDL_ARRAYORDER_ARGB, 0, 64, 8));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ARGB64_FLOAT_FOURCC, !SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_ARGB64_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ARGB64_FLOAT_INDEXED, !SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_ARGB64_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ARGB64_FLOAT_PACKED, !SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_ARGB64_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ARGB64_FLOAT_ARRAY, SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_ARGB64_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ARGB64_FLOAT_10BIT, !SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_ARGB64_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ARGB64_FLOAT_FLOAT, SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_ARGB64_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ARGB64_FLOAT_ALPHA, SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_ARGB64_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGRA64_FLOAT_FORMAT, SDL_PIXELFORMAT_BGRA64_FLOAT == SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_ARRAYF16, SDL_ARRAYORDER_BGRA, 0, 64, 8));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGRA64_FLOAT_FOURCC, !SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_BGRA64_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGRA64_FLOAT_INDEXED, !SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_BGRA64_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGRA64_FLOAT_PACKED, !SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_BGRA64_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGRA64_FLOAT_ARRAY, SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_BGRA64_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGRA64_FLOAT_10BIT, !SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_BGRA64_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGRA64_FLOAT_FLOAT, SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_BGRA64_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGRA64_FLOAT_ALPHA, SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_BGRA64_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ABGR64_FLOAT_FORMAT, SDL_PIXELFORMAT_ABGR64_FLOAT == SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_ARRAYF16, SDL_ARRAYORDER_ABGR, 0, 64, 8));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ABGR64_FLOAT_FOURCC, !SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_ABGR64_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ABGR64_FLOAT_INDEXED, !SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_ABGR64_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ABGR64_FLOAT_PACKED, !SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_ABGR64_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ABGR64_FLOAT_ARRAY, SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_ABGR64_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ABGR64_FLOAT_10BIT, !SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_ABGR64_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ABGR64_FLOAT_FLOAT, SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_ABGR64_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ABGR64_FLOAT_ALPHA, SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_ABGR64_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGB96_FLOAT_FORMAT, SDL_PIXELFORMAT_RGB96_FLOAT == SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_ARRAYF32, SDL_ARRAYORDER_RGB, 0, 96, 12));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGB96_FLOAT_FOURCC, !SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_RGB96_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGB96_FLOAT_INDEXED, !SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_RGB96_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGB96_FLOAT_PACKED, !SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_RGB96_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGB96_FLOAT_ARRAY, SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_RGB96_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGB96_FLOAT_10BIT, !SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_RGB96_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGB96_FLOAT_FLOAT, SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_RGB96_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGB96_FLOAT_ALPHA, !SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_RGB96_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGR96_FLOAT_FORMAT, SDL_PIXELFORMAT_BGR96_FLOAT == SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_ARRAYF32, SDL_ARRAYORDER_BGR, 0, 96, 12));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGR96_FLOAT_FOURCC, !SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_BGR96_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGR96_FLOAT_INDEXED, !SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_BGR96_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGR96_FLOAT_PACKED, !SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_BGR96_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGR96_FLOAT_ARRAY, SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_BGR96_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGR96_FLOAT_10BIT, !SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_BGR96_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGR96_FLOAT_FLOAT, SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_BGR96_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGR96_FLOAT_ALPHA, !SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_BGR96_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGBA128_FLOAT_FORMAT, SDL_PIXELFORMAT_RGBA128_FLOAT == SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_ARRAYF32, SDL_ARRAYORDER_RGBA, 0, 128, 16));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGBA128_FLOAT_FOURCC, !SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_RGBA128_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGBA128_FLOAT_INDEXED, !SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_RGBA128_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGBA128_FLOAT_PACKED, !SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_RGBA128_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGBA128_FLOAT_ARRAY, SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_RGBA128_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGBA128_FLOAT_10BIT, !SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_RGBA128_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGBA128_FLOAT_FLOAT, SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_RGBA128_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_RGBA128_FLOAT_ALPHA, SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_RGBA128_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ARGB128_FLOAT_FORMAT, SDL_PIXELFORMAT_ARGB128_FLOAT == SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_ARRAYF32, SDL_ARRAYORDER_ARGB, 0, 128, 16));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ARGB128_FLOAT_FOURCC, !SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_ARGB128_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ARGB128_FLOAT_INDEXED, !SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_ARGB128_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ARGB128_FLOAT_PACKED, !SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_ARGB128_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ARGB128_FLOAT_ARRAY, SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_ARGB128_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ARGB128_FLOAT_10BIT, !SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_ARGB128_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ARGB128_FLOAT_FLOAT, SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_ARGB128_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ARGB128_FLOAT_ALPHA, SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_ARGB128_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGRA128_FLOAT_FORMAT, SDL_PIXELFORMAT_BGRA128_FLOAT == SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_ARRAYF32, SDL_ARRAYORDER_BGRA, 0, 128, 16));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGRA128_FLOAT_FOURCC, !SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_BGRA128_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGRA128_FLOAT_INDEXED, !SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_BGRA128_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGRA128_FLOAT_PACKED, !SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_BGRA128_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGRA128_FLOAT_ARRAY, SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_BGRA128_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGRA128_FLOAT_10BIT, !SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_BGRA128_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGRA128_FLOAT_FLOAT, SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_BGRA128_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_BGRA128_FLOAT_ALPHA, SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_BGRA128_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ABGR128_FLOAT_FORMAT, SDL_PIXELFORMAT_ABGR128_FLOAT == SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_ARRAYF32, SDL_ARRAYORDER_ABGR, 0, 128, 16));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ABGR128_FLOAT_FOURCC, !SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_ABGR128_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ABGR128_FLOAT_INDEXED, !SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_ABGR128_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ABGR128_FLOAT_PACKED, !SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_ABGR128_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ABGR128_FLOAT_ARRAY, SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_ABGR128_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ABGR128_FLOAT_10BIT, !SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_ABGR128_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ABGR128_FLOAT_FLOAT, SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_ABGR128_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_ABGR128_FLOAT_ALPHA, SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_ABGR128_FLOAT));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_YV12_FORMAT, SDL_PIXELFORMAT_YV12 == SDL_DEFINE_PIXELFOURCC('Y', 'V', '1', '2'));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_YV12_FOURCC, SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_YV12));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_YV12_INDEXED, !SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_YV12));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_YV12_PACKED, !SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_YV12));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_YV12_ARRAY, !SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_YV12));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_YV12_10BIT, !SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_YV12));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_YV12_FLOAT, !SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_YV12));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_YV12_ALPHA, !SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_YV12));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_IYUV_FORMAT, SDL_PIXELFORMAT_IYUV == SDL_DEFINE_PIXELFOURCC('I', 'Y', 'U', 'V'));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_IYUV_FOURCC, SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_IYUV));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_IYUV_INDEXED, !SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_IYUV));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_IYUV_PACKED, !SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_IYUV));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_IYUV_ARRAY, !SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_IYUV));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_IYUV_10BIT, !SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_IYUV));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_IYUV_FLOAT, !SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_IYUV));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_IYUV_ALPHA, !SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_IYUV));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_YUY2_FORMAT, SDL_PIXELFORMAT_YUY2 == SDL_DEFINE_PIXELFOURCC('Y', 'U', 'Y', '2'));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_YUY2_FOURCC, SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_YUY2));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_YUY2_INDEXED, !SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_YUY2));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_YUY2_PACKED, !SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_YUY2));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_YUY2_ARRAY, !SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_YUY2));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_YUY2_10BIT, !SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_YUY2));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_YUY2_FLOAT, !SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_YUY2));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_YUY2_ALPHA, !SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_YUY2));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_UYVY_FORMAT, SDL_PIXELFORMAT_UYVY == SDL_DEFINE_PIXELFOURCC('U', 'Y', 'V', 'Y'));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_UYVY_FOURCC, SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_UYVY));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_UYVY_INDEXED, !SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_UYVY));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_UYVY_PACKED, !SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_UYVY));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_UYVY_ARRAY, !SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_UYVY));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_UYVY_10BIT, !SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_UYVY));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_UYVY_FLOAT, !SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_UYVY));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_UYVY_ALPHA, !SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_UYVY));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_YVYU_FORMAT, SDL_PIXELFORMAT_YVYU == SDL_DEFINE_PIXELFOURCC('Y', 'V', 'Y', 'U'));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_YVYU_FOURCC, SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_YVYU));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_YVYU_INDEXED, !SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_YVYU));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_YVYU_PACKED, !SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_YVYU));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_YVYU_ARRAY, !SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_YVYU));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_YVYU_10BIT, !SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_YVYU));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_YVYU_FLOAT, !SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_YVYU));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_YVYU_ALPHA, !SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_YVYU));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_NV12_FORMAT, SDL_PIXELFORMAT_NV12 == SDL_DEFINE_PIXELFOURCC('N', 'V', '1', '2'));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_NV12_FOURCC, SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_NV12));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_NV12_INDEXED, !SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_NV12));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_NV12_PACKED, !SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_NV12));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_NV12_ARRAY, !SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_NV12));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_NV12_10BIT, !SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_NV12));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_NV12_FLOAT, !SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_NV12));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_NV12_ALPHA, !SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_NV12));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_NV21_FORMAT, SDL_PIXELFORMAT_NV21 == SDL_DEFINE_PIXELFOURCC('N', 'V', '2', '1'));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_NV21_FOURCC, SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_NV21));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_NV21_INDEXED, !SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_NV21));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_NV21_PACKED, !SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_NV21));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_NV21_ARRAY, !SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_NV21));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_NV21_10BIT, !SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_NV21));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_NV21_FLOAT, !SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_NV21));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_NV21_ALPHA, !SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_NV21));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_P010_FORMAT, SDL_PIXELFORMAT_P010 == SDL_DEFINE_PIXELFOURCC('P', '0', '1', '0'));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_P010_FOURCC, SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_P010));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_P010_INDEXED, !SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_P010));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_P010_PACKED, !SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_P010));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_P010_ARRAY, !SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_P010));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_P010_10BIT, !SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_P010));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_P010_FLOAT, !SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_P010));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_P010_ALPHA, !SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_P010));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_EXTERNAL_OES_FORMAT, SDL_PIXELFORMAT_EXTERNAL_OES == SDL_DEFINE_PIXELFOURCC('O', 'E', 'S', ' '));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_EXTERNAL_OES_FOURCC, SDL_ISPIXELFORMAT_FOURCC(SDL_PIXELFORMAT_EXTERNAL_OES));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_EXTERNAL_OES_INDEXED, !SDL_ISPIXELFORMAT_INDEXED(SDL_PIXELFORMAT_EXTERNAL_OES));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_EXTERNAL_OES_PACKED, !SDL_ISPIXELFORMAT_PACKED(SDL_PIXELFORMAT_EXTERNAL_OES));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_EXTERNAL_OES_ARRAY, !SDL_ISPIXELFORMAT_ARRAY(SDL_PIXELFORMAT_EXTERNAL_OES));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_EXTERNAL_OES_10BIT, !SDL_ISPIXELFORMAT_10BIT(SDL_PIXELFORMAT_EXTERNAL_OES));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_EXTERNAL_OES_FLOAT, !SDL_ISPIXELFORMAT_FLOAT(SDL_PIXELFORMAT_EXTERNAL_OES));
SDL_COMPILE_TIME_ASSERT(SDL_PIXELFORMAT_EXTERNAL_OES_ALPHA, !SDL_ISPIXELFORMAT_ALPHA(SDL_PIXELFORMAT_EXTERNAL_OES));


/* Verify the colorspaces are laid out as expected */
SDL_COMPILE_TIME_ASSERT(SDL_COLORSPACE_SRGB_FORMAT, SDL_COLORSPACE_SRGB ==
        SDL_DEFINE_COLORSPACE(SDL_COLOR_TYPE_RGB,
                                 SDL_COLOR_RANGE_FULL,
                                 SDL_COLOR_PRIMARIES_BT709,
                                 SDL_TRANSFER_CHARACTERISTICS_SRGB,
                                 SDL_MATRIX_COEFFICIENTS_IDENTITY,
                                 SDL_CHROMA_LOCATION_NONE));
SDL_COMPILE_TIME_ASSERT(SDL_COLORSPACE_SRGB_LINEAR_FORMAT, SDL_COLORSPACE_SRGB_LINEAR ==
        SDL_DEFINE_COLORSPACE(SDL_COLOR_TYPE_RGB,
                                 SDL_COLOR_RANGE_FULL,
                                 SDL_COLOR_PRIMARIES_BT709,
                                 SDL_TRANSFER_CHARACTERISTICS_LINEAR,
                                 SDL_MATRIX_COEFFICIENTS_IDENTITY,
                                 SDL_CHROMA_LOCATION_NONE));

SDL_COMPILE_TIME_ASSERT(SDL_COLORSPACE_HDR10_FORMAT, SDL_COLORSPACE_HDR10 ==
        SDL_DEFINE_COLORSPACE(SDL_COLOR_TYPE_RGB,
                                 SDL_COLOR_RANGE_FULL,
                                 SDL_COLOR_PRIMARIES_BT2020,
                                 SDL_TRANSFER_CHARACTERISTICS_PQ,
                                 SDL_MATRIX_COEFFICIENTS_IDENTITY,
                                 SDL_CHROMA_LOCATION_NONE));

SDL_COMPILE_TIME_ASSERT(SDL_COLORSPACE_JPEG_FORMAT, SDL_COLORSPACE_JPEG ==
        SDL_DEFINE_COLORSPACE(SDL_COLOR_TYPE_YCBCR,
                                 SDL_COLOR_RANGE_FULL,
                                 SDL_COLOR_PRIMARIES_BT709,
                                 SDL_TRANSFER_CHARACTERISTICS_BT601,
                                 SDL_MATRIX_COEFFICIENTS_BT601,
                                 SDL_CHROMA_LOCATION_NONE));

SDL_COMPILE_TIME_ASSERT(SDL_COLORSPACE_BT601_LIMITED_FORMAT, SDL_COLORSPACE_BT601_LIMITED ==
        SDL_DEFINE_COLORSPACE(SDL_COLOR_TYPE_YCBCR,
                                 SDL_COLOR_RANGE_LIMITED,
                                 SDL_COLOR_PRIMARIES_BT601,
                                 SDL_TRANSFER_CHARACTERISTICS_BT601,
                                 SDL_MATRIX_COEFFICIENTS_BT601,
                                 SDL_CHROMA_LOCATION_LEFT));

SDL_COMPILE_TIME_ASSERT(SDL_COLORSPACE_BT601_FULL_FORMAT, SDL_COLORSPACE_BT601_FULL ==
        SDL_DEFINE_COLORSPACE(SDL_COLOR_TYPE_YCBCR,
                                 SDL_COLOR_RANGE_FULL,
                                 SDL_COLOR_PRIMARIES_BT601,
                                 SDL_TRANSFER_CHARACTERISTICS_BT601,
                                 SDL_MATRIX_COEFFICIENTS_BT601,
                                 SDL_CHROMA_LOCATION_LEFT));

SDL_COMPILE_TIME_ASSERT(SDL_COLORSPACE_BT709_LIMITED_FORMAT, SDL_COLORSPACE_BT709_LIMITED ==
        SDL_DEFINE_COLORSPACE(SDL_COLOR_TYPE_YCBCR,
                                 SDL_COLOR_RANGE_LIMITED,
                                 SDL_COLOR_PRIMARIES_BT709,
                                 SDL_TRANSFER_CHARACTERISTICS_BT709,
                                 SDL_MATRIX_COEFFICIENTS_BT709,
                                 SDL_CHROMA_LOCATION_LEFT));

SDL_COMPILE_TIME_ASSERT(SDL_COLORSPACE_BT709_FULL_FORMAT, SDL_COLORSPACE_BT709_FULL ==
        SDL_DEFINE_COLORSPACE(SDL_COLOR_TYPE_YCBCR,
                                 SDL_COLOR_RANGE_FULL,
                                 SDL_COLOR_PRIMARIES_BT709,
                                 SDL_TRANSFER_CHARACTERISTICS_BT709,
                                 SDL_MATRIX_COEFFICIENTS_BT709,
                                 SDL_CHROMA_LOCATION_LEFT));

SDL_COMPILE_TIME_ASSERT(SDL_COLORSPACE_BT2020_LIMITED_FORMAT, SDL_COLORSPACE_BT2020_LIMITED ==
        SDL_DEFINE_COLORSPACE(SDL_COLOR_TYPE_YCBCR,
                                 SDL_COLOR_RANGE_LIMITED,
                                 SDL_COLOR_PRIMARIES_BT2020,
                                 SDL_TRANSFER_CHARACTERISTICS_PQ,
                                 SDL_MATRIX_COEFFICIENTS_BT2020_NCL,
                                 SDL_CHROMA_LOCATION_LEFT));

SDL_COMPILE_TIME_ASSERT(SDL_COLORSPACE_BT2020_FULL_FORMAT, SDL_COLORSPACE_BT2020_FULL ==
        SDL_DEFINE_COLORSPACE(SDL_COLOR_TYPE_YCBCR,
                                 SDL_COLOR_RANGE_FULL,
                                 SDL_COLOR_PRIMARIES_BT2020,
                                 SDL_TRANSFER_CHARACTERISTICS_PQ,
                                 SDL_MATRIX_COEFFICIENTS_BT2020_NCL,
                                 SDL_CHROMA_LOCATION_LEFT));
/* Test case functions */

/**
 * Call to SDL_GetPixelFormatName
 *
 * \sa SDL_GetPixelFormatName
 */
static int SDLCALL pixels_getPixelFormatName(void *arg)
{
    const char *unknownFormat = "SDL_PIXELFORMAT_UNKNOWN";
    const char *error;
    int i;
    SDL_PixelFormat format;
    const char *result;

    /* Blank/undefined format */
    format = SDL_PIXELFORMAT_UNKNOWN;
    SDLTest_Log("RGB Format: %s (%d)", unknownFormat, format);

    /* Get name of format */
    result = SDL_GetPixelFormatName(format);
    SDLTest_AssertPass("Call to SDL_GetPixelFormatName()");
    SDLTest_AssertCheck(result != NULL, "Verify result is not NULL");
    if (result != NULL) {
        SDLTest_AssertCheck(result[0] != '\0', "Verify result is non-empty");
        SDLTest_AssertCheck(SDL_strcmp(result, unknownFormat) == 0,
                            "Verify result text; expected: %s, got %s", unknownFormat, result);
    }

    /* RGB formats */
    for (i = 0; i < g_numAllFormats; i++) {
        format = g_AllFormats[i];
        SDLTest_Log("RGB Format: %s (%d)", g_AllFormatsVerbose[i], format);

        /* Get name of format */
        result = SDL_GetPixelFormatName(format);
        SDLTest_AssertPass("Call to SDL_GetPixelFormatName()");
        SDLTest_AssertCheck(result != NULL, "Verify result is not NULL");
        if (result != NULL) {
            SDLTest_AssertCheck(result[0] != '\0', "Verify result is non-empty");
            SDLTest_AssertCheck(SDL_strcmp(result, g_AllFormatsVerbose[i]) == 0,
                                "Verify result text; expected: %s, got %s", g_AllFormatsVerbose[i], result);
        }
    }

    /* Negative cases */

    /* Invalid Formats */
    SDL_ClearError();
    SDLTest_AssertPass("Call to SDL_ClearError()");
    for (i = 0; i < g_numInvalidPixelFormats; i++) {
        format = g_invalidPixelFormats[i];
        result = SDL_GetPixelFormatName(format);
        SDLTest_AssertPass("Call to SDL_GetPixelFormatName(%d)", format);
        SDLTest_AssertCheck(result != NULL, "Verify result is not NULL");
        if (result != NULL) {
            SDLTest_AssertCheck(result[0] != '\0',
                                "Verify result is non-empty; got: %s", result);
            SDLTest_AssertCheck(SDL_strcmp(result, g_invalidPixelFormatsVerbose[i]) == 0,
                                "Validate name is UNKNOWN, expected: '%s', got: '%s'", g_invalidPixelFormatsVerbose[i], result);
        }
        error = SDL_GetError();
        SDLTest_AssertPass("Call to SDL_GetError()");
        SDLTest_AssertCheck(error == NULL || error[0] == '\0', "Validate that error message is empty");
    }

    return TEST_COMPLETED;
}

/**
 * Call to SDL_GetPixelFormatDetails
 */
static int SDLCALL pixels_getPixelFormatDetails(void *arg)
{
    const char *unknownFormat = "SDL_PIXELFORMAT_UNKNOWN";
    const char *expectedError = "Unknown pixel format";
    const char *error;
    int i;
    SDL_PixelFormat format;
    Uint32 masks;
    const SDL_PixelFormatDetails *result;

    /* Blank/unknown format */
    format = SDL_PIXELFORMAT_UNKNOWN;
    SDLTest_Log("Pixel Format: %s (%d)", unknownFormat, format);

    /* Allocate format */
    result = SDL_GetPixelFormatDetails(format);
    SDLTest_AssertPass("Call to SDL_GetPixelFormatDetails()");
    SDLTest_AssertCheck(result != NULL, "Verify result is not NULL");
    if (result != NULL) {
        SDLTest_AssertCheck(result->format == format, "Verify value of result.format; expected: %d, got %d", format, result->format);
        SDLTest_AssertCheck(result->bits_per_pixel == 0,
                            "Verify value of result.bits_per_pixel; expected: 0, got %u",
                            result->bits_per_pixel);
        SDLTest_AssertCheck(result->bytes_per_pixel == 0,
                            "Verify value of result.bytes_per_pixel; expected: 0, got %u",
                            result->bytes_per_pixel);
        masks = result->Rmask | result->Gmask | result->Bmask | result->Amask;
        SDLTest_AssertCheck(masks == 0, "Verify value of result.[RGBA]mask combined; expected: 0, got %" SDL_PRIu32, masks);
    }

    /* RGB formats */
    for (i = 0; i < g_numAllFormats; i++) {
        format = g_AllFormats[i];
        SDLTest_Log("Pixel Format: %s (%d)", g_AllFormatsVerbose[i], format);

        /* Allocate format */
        result = SDL_GetPixelFormatDetails(format);
        SDLTest_AssertPass("Call to SDL_GetPixelFormatDetails()");
        SDLTest_AssertCheck(result != NULL, "Verify result is not NULL");
        if (result != NULL) {
            SDLTest_AssertCheck(result->format == format, "Verify value of result.format; expected: %d, got %d", format, result->format);
            if (!SDL_ISPIXELFORMAT_FOURCC(format)) {
                SDLTest_AssertCheck(result->bits_per_pixel > 0,
                                    "Verify value of result.bits_per_pixel; expected: >0, got %u",
                                    result->bits_per_pixel);
                SDLTest_AssertCheck(result->bytes_per_pixel > 0,
                                    "Verify value of result.bytes_per_pixel; expected: >0, got %u",
                                    result->bytes_per_pixel);
                if (!SDL_ISPIXELFORMAT_INDEXED(format)) {
                    masks = result->Rmask | result->Gmask | result->Bmask | result->Amask;
                    SDLTest_AssertCheck(masks > 0, "Verify value of result.[RGBA]mask combined; expected: >0, got %" SDL_PRIu32, masks);
                    if (SDL_ISPIXELFORMAT_10BIT(format)) {
                        SDLTest_AssertCheck(result->Rbits == 10 && result->Gbits == 10 && result->Bbits == 10, "Verify value of result.[RGB]bits; expected: 10, got %d/%d/%d", result->Rbits, result->Gbits, result->Bbits);
                    } else if (SDL_BITSPERPIXEL(format) == 32) {
                        SDLTest_AssertCheck(result->Rbits == 8 && result->Gbits == 8 && result->Bbits == 8, "Verify value of result.[RGB]bits; expected: 8, got %d/%d/%d", result->Rbits, result->Gbits, result->Bbits);
                    }
                }
            }
        }
    }

    /* Negative cases */

    /* Invalid Formats */
    for (i = 0; i < g_numInvalidPixelFormats; i++) {
        SDL_ClearError();
        SDLTest_AssertPass("Call to SDL_ClearError()");
        format = g_invalidPixelFormats[i];
        result = SDL_GetPixelFormatDetails(format);
        SDLTest_AssertPass("Call to SDL_GetPixelFormatDetails(%d)", format);
        SDLTest_AssertCheck(result == NULL, "Verify result is NULL");
        error = SDL_GetError();
        SDLTest_AssertPass("Call to SDL_GetError()");
        SDLTest_AssertCheck(error != NULL, "Validate that error message was not NULL");
        if (error != NULL) {
            SDLTest_AssertCheck(SDL_strcmp(error, expectedError) == 0,
                                "Validate error message, expected: '%s', got: '%s'", expectedError, error);
        }
    }

    return TEST_COMPLETED;
}

/**
 * Call to SDL_CreatePalette and SDL_DestroyPalette
 *
 * \sa SDL_CreatePalette
 * \sa SDL_DestroyPalette
 */
static int SDLCALL pixels_allocFreePalette(void *arg)
{
    const char *expectedError = "Parameter 'ncolors' is invalid";
    const char *error;
    int variation;
    int i;
    int ncolors;
    SDL_Palette *result;

    /* Allocate palette */
    for (variation = 1; variation <= 3; variation++) {
        switch (variation) {
        /* Just one color */
        default:
        case 1:
            ncolors = 1;
            break;
        /* Two colors */
        case 2:
            ncolors = 2;
            break;
        /* More than two colors */
        case 3:
            ncolors = SDLTest_RandomIntegerInRange(8, 16);
            break;
        }

        result = SDL_CreatePalette(ncolors);
        SDLTest_AssertPass("Call to SDL_CreatePalette(%d)", ncolors);
        SDLTest_AssertCheck(result != NULL, "Verify result is not NULL");
        if (result != NULL) {
            SDLTest_AssertCheck(result->ncolors == ncolors, "Verify value of result.ncolors; expected: %u, got %u", ncolors, result->ncolors);
            if (result->ncolors > 0) {
                SDLTest_AssertCheck(result->colors != NULL, "Verify value of result.colors is not NULL");
                if (result->colors != NULL) {
                    for (i = 0; i < result->ncolors; i++) {
                        SDLTest_AssertCheck(result->colors[i].r == 255, "Verify value of result.colors[%d].r; expected: 255, got %u", i, result->colors[i].r);
                        SDLTest_AssertCheck(result->colors[i].g == 255, "Verify value of result.colors[%d].g; expected: 255, got %u", i, result->colors[i].g);
                        SDLTest_AssertCheck(result->colors[i].b == 255, "Verify value of result.colors[%d].b; expected: 255, got %u", i, result->colors[i].b);
                    }
                }
            }

            /* Deallocate again */
            SDL_DestroyPalette(result);
            SDLTest_AssertPass("Call to SDL_DestroyPalette()");
        }
    }

    /* Negative cases */

    /* Invalid number of colors */
    for (ncolors = 0; ncolors > -3; ncolors--) {
        SDL_ClearError();
        SDLTest_AssertPass("Call to SDL_ClearError()");
        result = SDL_CreatePalette(ncolors);
        SDLTest_AssertPass("Call to SDL_CreatePalette(%d)", ncolors);
        SDLTest_AssertCheck(result == NULL, "Verify result is NULL");
        error = SDL_GetError();
        SDLTest_AssertPass("Call to SDL_GetError()");
        SDLTest_AssertCheck(error != NULL, "Validate that error message was not NULL");
        if (error != NULL) {
            SDLTest_AssertCheck(SDL_strcmp(error, expectedError) == 0,
                                "Validate error message, expected: '%s', got: '%s'", expectedError, error);
        }
    }

    /* Invalid free pointer */
    SDL_ClearError();
    SDLTest_AssertPass("Call to SDL_ClearError()");
    SDL_DestroyPalette(NULL);
    SDLTest_AssertPass("Call to SDL_DestroyPalette(NULL)");
    error = SDL_GetError();
    SDLTest_AssertPass("Call to SDL_GetError()");
    SDLTest_AssertCheck(error == NULL || error[0] == '\0', "Validate that error message is empty");

    return TEST_COMPLETED;
}

/**
 * Call to SDL_SaveBMP and SDL_LoadBMP
 *
 * \sa SDL_SaveBMP
 * \sa SDL_LoadBMP
 */
static int SDLCALL pixels_saveLoadBMP(void *arg)
{
    int i;
    SDL_Surface *surface;
    bool result;

    for (i = 0; i < g_numAllFormats; i++) {
        SDL_PixelFormat format = g_AllFormats[i];

        if (SDL_ISPIXELFORMAT_FOURCC(format)) {
            continue;
        }
        if (SDL_ISPIXELFORMAT_INDEXED(format)) {
            /* We'll test BMP with palette another time */
            continue;
        }

        SDLTest_Log("Pixel Format: %s (%d)", g_AllFormatsVerbose[i], format);

        /* Create surface */
        surface = SDL_CreateSurface(1, 1, format);
        SDLTest_AssertCheck(surface != NULL, "Verify surface is not NULL");

        /* Fill with white */
        result = SDL_ClearSurface(surface, 1.0f, 1.0f, 1.0f, 1.0f);
        SDLTest_AssertCheck(result, "Verify SDL_ClearSurface() succeeded");

        /* Save as BMP */
        result = SDL_SaveBMP(surface, "test.bmp");
        SDLTest_AssertCheck(result, "Verify SDL_SaveBMP() succeeded");
        SDL_DestroySurface(surface);

        /* Load BMP */
        surface = SDL_LoadBMP("test.bmp");
        SDLTest_AssertCheck(surface != NULL, "Verify SDL_LoadBMP() succeeded");

        /* Remove BMP */
        result = SDL_RemovePath("test.bmp");
        SDLTest_AssertCheck(result, "Verify SDL_RemovePath() succeeded");

        /* Verify the BMP contents */
        if (surface) {
            Uint8 *pixels = (Uint8 *)surface->pixels;
            if (SDL_ISPIXELFORMAT_ALPHA(format)) {
                SDLTest_AssertCheck(surface->format == SDL_PIXELFORMAT_ARGB8888, "Verify BMP surface format, expected %s, got %s", SDL_GetPixelFormatName(SDL_PIXELFORMAT_ARGB8888), SDL_GetPixelFormatName(surface->format));
                SDLTest_AssertCheck(pixels[0] == 255 &&
                                    pixels[1] == 255 &&
                                    pixels[2] == 255 &&
                                    pixels[3] == 255,
                                    "Verify BMP colors, expected 255/255/255/255 got %d/%d/%d/%d", pixels[0], pixels[1], pixels[2], pixels[3]);
            } else {
                SDLTest_AssertCheck(surface->format == SDL_PIXELFORMAT_BGR24, "Verify BMP surface format, expected %s, got %s", SDL_GetPixelFormatName(SDL_PIXELFORMAT_BGR24), SDL_GetPixelFormatName(surface->format));
                SDLTest_AssertCheck(pixels[0] == 255 &&
                                    pixels[1] == 255 &&
                                    pixels[2] == 255,
                                    "Verify BMP colors, expected 255/255/255 got %d/%d/%d", pixels[0], pixels[1], pixels[2]);
            }
            SDL_DestroySurface(surface);
        }
    }

    /* Test large formats */
    for (i = 0; i < SDL_arraysize(g_AllLargeFormats); i++) {
        SDL_PixelFormat format = g_AllLargeFormats[i];

        SDLTest_Log("Pixel Format: %s (%d)", SDL_GetPixelFormatName(format), format);

        /* Create surface */
        surface = SDL_CreateSurface(1, 1, format);
        SDLTest_AssertCheck(surface != NULL, "Verify surface is not NULL");

        /* Fill with white */
        result = SDL_ClearSurface(surface, 1.0f, 1.0f, 1.0f, 1.0f);
        SDLTest_AssertCheck(result, "Verify SDL_ClearSurface() succeeded");

        /* Save as BMP */
        result = SDL_SaveBMP(surface, "test.bmp");
        SDLTest_AssertCheck(result, "Verify SDL_SaveBMP() succeeded");
        SDL_DestroySurface(surface);

        /* Load BMP */
        surface = SDL_LoadBMP("test.bmp");
        SDLTest_AssertCheck(surface != NULL, "Verify SDL_LoadBMP() succeeded");

        /* Remove BMP */
        result = SDL_RemovePath("test.bmp");
        SDLTest_AssertCheck(result, "Verify SDL_RemovePath() succeeded");

        /* Verify the BMP contents */
        if (surface) {
            Uint8 *pixels = (Uint8 *)surface->pixels;
            if (SDL_ISPIXELFORMAT_ALPHA(format)) {
                SDLTest_AssertCheck(surface->format == SDL_PIXELFORMAT_ARGB8888, "Verify BMP surface format, expected %s, got %s", SDL_GetPixelFormatName(SDL_PIXELFORMAT_ARGB8888), SDL_GetPixelFormatName(surface->format));
                SDLTest_AssertCheck(pixels[0] == 255 &&
                                    pixels[1] == 255 &&
                                    pixels[2] == 255 &&
                                    pixels[3] == 255,
                                    "Verify BMP colors, expected 255/255/255/255 got %d/%d/%d/%d", pixels[0], pixels[1], pixels[2], pixels[3]);
            } else {
                SDLTest_AssertCheck(surface->format == SDL_PIXELFORMAT_BGR24, "Verify BMP surface format, expected %s, got %s", SDL_GetPixelFormatName(SDL_PIXELFORMAT_BGR24), SDL_GetPixelFormatName(surface->format));
                SDLTest_AssertCheck(pixels[0] == 255 &&
                                    pixels[1] == 255 &&
                                    pixels[2] == 255,
                                    "Verify BMP colors, expected 255/255/255 got %d/%d/%d", pixels[0], pixels[1], pixels[2]);
            }
            SDL_DestroySurface(surface);
        }
    }

    return TEST_COMPLETED;
}

/**
 * Call to SDL_SavePNG and SDL_LoadPNG
 *
 * \sa SDL_SavePNG
 * \sa SDL_LoadPNG
 */
static int SDLCALL pixels_saveLoadPNG(void *arg)
{
    int i;
    SDL_Surface *surface;
    bool result;

    for (i = 0; i < g_numAllFormats; i++) {
        SDL_PixelFormat format = g_AllFormats[i];

        if (SDL_ISPIXELFORMAT_FOURCC(format)) {
            continue;
        }
        if (SDL_ISPIXELFORMAT_INDEXED(format)) {
            /* We'll test PNG with palette another time */
            continue;
        }

        SDLTest_Log("Pixel Format: %s (%d)", g_AllFormatsVerbose[i], format);

        /* Create surface */
        surface = SDL_CreateSurface(1, 1, format);
        SDLTest_AssertCheck(surface != NULL, "Verify surface is not NULL");

        /* Fill with white */
        result = SDL_ClearSurface(surface, 1.0f, 1.0f, 1.0f, 1.0f);
        SDLTest_AssertCheck(result, "Verify SDL_ClearSurface() succeeded");

        /* Save as PNG */
        result = SDL_SavePNG(surface, "test.png");
        SDLTest_AssertCheck(result, "Verify SDL_SavePNG() succeeded");
        SDL_DestroySurface(surface);

        /* Load PNG */
        surface = SDL_LoadPNG("test.png");
        SDLTest_AssertCheck(surface != NULL, "Verify SDL_LoadPNG() succeeded");

        /* Remove PNG */
        result = SDL_RemovePath("test.png");
        SDLTest_AssertCheck(result, "Verify SDL_RemovePath() succeeded");

        /* Verify the PNG contents */
        if (surface) {
            Uint8 *pixels = (Uint8 *)surface->pixels;
            SDLTest_AssertCheck(surface->format == SDL_PIXELFORMAT_RGBA32, "Verify PNG surface format, expected %s, got %s", SDL_GetPixelFormatName(SDL_PIXELFORMAT_RGBA32), SDL_GetPixelFormatName(surface->format));
            SDLTest_AssertCheck(pixels[0] == 255 &&
                                pixels[1] == 255 &&
                                pixels[2] == 255 &&
                                pixels[3] == 255,
                                "Verify PNG colors, expected 255/255/255/255 got %d/%d/%d/%d", pixels[0], pixels[1], pixels[2], pixels[3]);
            SDL_DestroySurface(surface);
        }
    }

    /* Test large formats */
    for (i = 0; i < SDL_arraysize(g_AllLargeFormats); i++) {
        SDL_PixelFormat format = g_AllLargeFormats[i];

        SDLTest_Log("Pixel Format: %s (%d)", SDL_GetPixelFormatName(format), format);

        /* Create surface */
        surface = SDL_CreateSurface(1, 1, format);
        SDLTest_AssertCheck(surface != NULL, "Verify surface is not NULL");

        /* Fill with white */
        result = SDL_ClearSurface(surface, 1.0f, 1.0f, 1.0f, 1.0f);
        SDLTest_AssertCheck(result, "Verify SDL_ClearSurface() succeeded");

        /* Save as PNG */
        result = SDL_SavePNG(surface, "test.png");
        SDLTest_AssertCheck(result, "Verify SDL_SavePNG() succeeded");
        SDL_DestroySurface(surface);

        /* Load PNG */
        surface = SDL_LoadPNG("test.png");
        SDLTest_AssertCheck(surface != NULL, "Verify SDL_LoadPNG() succeeded");

        /* Remove PNG */
        result = SDL_RemovePath("test.png");
        SDLTest_AssertCheck(result, "Verify SDL_RemovePath() succeeded");

        /* Verify the PNG contents */
        if (surface) {
            Uint8 *pixels = (Uint8 *)surface->pixels;
            SDLTest_AssertCheck(surface->format == SDL_PIXELFORMAT_RGBA32, "Verify PNG surface format, expected %s, got %s", SDL_GetPixelFormatName(SDL_PIXELFORMAT_RGBA32), SDL_GetPixelFormatName(surface->format));
            SDLTest_AssertCheck(pixels[0] == 255 &&
                                pixels[1] == 255 &&
                                pixels[2] == 255 &&
                                pixels[3] == 255,
                                "Verify PNG colors, expected 255/255/255/255 got %d/%d/%d/%d", pixels[0], pixels[1], pixels[2], pixels[3]);
            SDL_DestroySurface(surface);
        }
    }

    return TEST_COMPLETED;
}

/* ================= Test References ================== */

/* Pixels test cases */
static const SDLTest_TestCaseReference pixelsTestGetPixelFormatName = {
    pixels_getPixelFormatName, "pixels_getPixelFormatName", "Call to SDL_GetPixelFormatName", TEST_ENABLED
};

static const SDLTest_TestCaseReference pixelsTestGetPixelFormatDetails = {
    pixels_getPixelFormatDetails, "pixels_getPixelFormatDetails", "Call to SDL_GetPixelFormatDetails", TEST_ENABLED
};

static const SDLTest_TestCaseReference pixelsTestAllocFreePalette = {
    pixels_allocFreePalette, "pixels_allocFreePalette", "Call to SDL_CreatePalette and SDL_DestroyPalette", TEST_ENABLED
};

static const SDLTest_TestCaseReference pixelsTestSaveLoadBMP = {
    pixels_saveLoadBMP, "pixels_saveLoadBMP", "Call to SDL_SaveBMP and SDL_LoadBMP", TEST_ENABLED
};

static const SDLTest_TestCaseReference pixelsTestSaveLoadPNG = {
    pixels_saveLoadPNG, "pixels_saveLoadPNG", "Call to SDL_SavePNG and SDL_LoadPNG", TEST_ENABLED
};

/* Sequence of Pixels test cases */
static const SDLTest_TestCaseReference *pixelsTests[] = {
    &pixelsTestGetPixelFormatName,
    &pixelsTestGetPixelFormatDetails,
    &pixelsTestAllocFreePalette,
    &pixelsTestSaveLoadBMP,
    &pixelsTestSaveLoadPNG,
    NULL
};

/* Pixels test suite (global) */
SDLTest_TestSuiteReference pixelsTestSuite = {
    "Pixels",
    NULL,
    pixelsTests,
    NULL
};
