# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Dict, List, Mapping, Optional, TYPE_CHECKING, Union, overload

from .._utils.model_base import Model as _Model, rest_field

if TYPE_CHECKING:
    from .. import models as _models


class ElseCondition(_Model):
    """The else block of storage task operation.

    :ivar operations: List of operations to execute in the else block. Required.
    :vartype operations: list[~azure.mgmt.storageactions.models.StorageTaskOperation]
    """

    operations: List["_models.StorageTaskOperation"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """List of operations to execute in the else block. Required."""

    @overload
    def __init__(
        self,
        *,
        operations: List["_models.StorageTaskOperation"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ErrorAdditionalInfo(_Model):
    """The resource management error additional info.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_Model):
    """The error detail.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.storageactions.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.storageactions.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[List["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[List["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_Model):
    """Error response.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.storageactions.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class IfCondition(_Model):
    """The if block of storage task operation.

    :ivar condition: Condition predicate to evaluate each object. See
     `https://aka.ms/storagetaskconditions <https://aka.ms/storagetaskconditions>`_ for valid
     properties and operators. Required.
    :vartype condition: str
    :ivar operations: List of operations to execute when the condition predicate satisfies.
     Required.
    :vartype operations: list[~azure.mgmt.storageactions.models.StorageTaskOperation]
    """

    condition: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Condition predicate to evaluate each object. See `https://aka.ms/storagetaskconditions
     <https://aka.ms/storagetaskconditions>`_ for valid properties and operators. Required."""
    operations: List["_models.StorageTaskOperation"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """List of operations to execute when the condition predicate satisfies. Required."""

    @overload
    def __init__(
        self,
        *,
        condition: str,
        operations: List["_models.StorageTaskOperation"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManagedServiceIdentity(_Model):
    """Managed service identity (system assigned and/or user assigned identities).

    :ivar principal_id: The service principal ID of the system assigned identity. This property
     will only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the system assigned identity. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: The type of managed identity assigned to this resource. Required. Known values are:
     "None", "SystemAssigned", "UserAssigned", and "SystemAssigned,UserAssigned".
    :vartype type: str or ~azure.mgmt.storageactions.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The identities assigned to this resource by the user.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.storageactions.models.UserAssignedIdentity]
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The service principal ID of the system assigned identity. This property will only be provided
     for a system assigned identity."""
    tenant_id: Optional[str] = rest_field(name="tenantId", visibility=["read"])
    """The tenant ID of the system assigned identity. This property will only be provided for a system
     assigned identity."""
    type: Union[str, "_models.ManagedServiceIdentityType"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of managed identity assigned to this resource. Required. Known values are: \"None\",
     \"SystemAssigned\", \"UserAssigned\", and \"SystemAssigned,UserAssigned\"."""
    user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = rest_field(
        name="userAssignedIdentities", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identities assigned to this resource by the user."""

    @overload
    def __init__(
        self,
        *,
        type: Union[str, "_models.ManagedServiceIdentityType"],
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Operation(_Model):
    """REST API Operation.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for Azure Resource Manager/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.storageactions.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.storageactions.models.Origin
    :ivar action_type: Extensible enum. Indicates the action type. "Internal" refers to actions
     that are for internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.storageactions.models.ActionType
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     \"Microsoft.Compute/virtualMachines/write\",
     \"Microsoft.Compute/virtualMachines/capture/action\"."""
    is_data_action: Optional[bool] = rest_field(name="isDataAction", visibility=["read"])
    """Whether the operation applies to data-plane. This is \"true\" for data-plane operations and
     \"false\" for Azure Resource Manager/control-plane operations."""
    display: Optional["_models.OperationDisplay"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Localized display information for this particular operation."""
    origin: Optional[Union[str, "_models.Origin"]] = rest_field(visibility=["read"])
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
     logs UX. Default value is \"user,system\". Known values are: \"user\", \"system\", and
     \"user,system\"."""
    action_type: Optional[Union[str, "_models.ActionType"]] = rest_field(name="actionType", visibility=["read"])
    """Extensible enum. Indicates the action type. \"Internal\" refers to actions that are for
     internal only APIs. \"Internal\""""

    @overload
    def __init__(
        self,
        *,
        display: Optional["_models.OperationDisplay"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OperationDisplay(_Model):
    """Localized display information for and operation.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    provider: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly form of the resource provider name, e.g. \"Microsoft Monitoring
     Insights\" or \"Microsoft Compute\"."""
    resource: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly name of the resource type related to this operation. E.g. \"Virtual
     Machines\" or \"Job Schedule Collections\"."""
    operation: Optional[str] = rest_field(visibility=["read"])
    """The concise, localized friendly name for the operation; suitable for dropdowns. E.g. \"Create
     or Update Virtual Machine\", \"Restart Virtual Machine\"."""
    description: Optional[str] = rest_field(visibility=["read"])
    """The short, localized friendly description of the operation; suitable for tool tips and detailed
     views."""


class Resource(_Model):
    """Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.storageactions.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class ProxyResource(Resource):
    """Proxy Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.storageactions.models.SystemData
    """


class TrackedResource(Resource):
    """Tracked Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.storageactions.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    location: str = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StorageTask(TrackedResource):
    """Represents Storage Task.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.storageactions.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar identity: The managed service identity of the resource. Required.
    :vartype identity: ~azure.mgmt.storageactions.models.ManagedServiceIdentity
    :ivar properties: Properties of the storage task. Required.
    :vartype properties: ~azure.mgmt.storageactions.models.StorageTaskProperties
    """

    identity: "_models.ManagedServiceIdentity" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The managed service identity of the resource. Required."""
    properties: "_models.StorageTaskProperties" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Properties of the storage task. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        identity: "_models.ManagedServiceIdentity",
        properties: "_models.StorageTaskProperties",
        tags: Optional[Dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StorageTaskAction(_Model):
    """The storage task action represents conditional statements and operations to be performed on
    target objects.

    :ivar if_property: The if block of storage task operation. Required.
    :vartype if_property: ~azure.mgmt.storageactions.models.IfCondition
    :ivar else_property: The else block of storage task operation.
    :vartype else_property: ~azure.mgmt.storageactions.models.ElseCondition
    """

    if_property: "_models.IfCondition" = rest_field(
        name="if", visibility=["read", "create", "update", "delete", "query"]
    )
    """The if block of storage task operation. Required."""
    else_property: Optional["_models.ElseCondition"] = rest_field(
        name="else", visibility=["read", "create", "update", "delete", "query"]
    )
    """The else block of storage task operation."""

    @overload
    def __init__(
        self,
        *,
        if_property: "_models.IfCondition",
        else_property: Optional["_models.ElseCondition"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StorageTaskAssignment(_Model):
    """Storage Task Assignment associated with this Storage Task.

    :ivar id: Resource ID of the Storage Task Assignment.
    :vartype id: str
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Resource ID of the Storage Task Assignment."""


class StorageTaskOperation(_Model):
    """Represents an operation to be performed on the object.

    :ivar name: The operation to be performed on the object. Required. Known values are:
     "SetBlobTier", "SetBlobTags", "SetBlobImmutabilityPolicy", "SetBlobLegalHold", "SetBlobExpiry",
     "DeleteBlob", and "UndeleteBlob".
    :vartype name: str or ~azure.mgmt.storageactions.models.StorageTaskOperationName
    :ivar parameters: Key-value parameters for the operation.
    :vartype parameters: dict[str, str]
    :ivar on_success: Action to be taken when the operation is successful for a object. "continue"
    :vartype on_success: str or ~azure.mgmt.storageactions.models.OnSuccess
    :ivar on_failure: Action to be taken when the operation fails for a object. "break"
    :vartype on_failure: str or ~azure.mgmt.storageactions.models.OnFailure
    """

    name: Union[str, "_models.StorageTaskOperationName"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The operation to be performed on the object. Required. Known values are: \"SetBlobTier\",
     \"SetBlobTags\", \"SetBlobImmutabilityPolicy\", \"SetBlobLegalHold\", \"SetBlobExpiry\",
     \"DeleteBlob\", and \"UndeleteBlob\"."""
    parameters: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Key-value parameters for the operation."""
    on_success: Optional[Union[str, "_models.OnSuccess"]] = rest_field(
        name="onSuccess", visibility=["read", "create", "update", "delete", "query"]
    )
    """Action to be taken when the operation is successful for a object. \"continue\""""
    on_failure: Optional[Union[str, "_models.OnFailure"]] = rest_field(
        name="onFailure", visibility=["read", "create", "update", "delete", "query"]
    )
    """Action to be taken when the operation fails for a object. \"break\""""

    @overload
    def __init__(
        self,
        *,
        name: Union[str, "_models.StorageTaskOperationName"],
        parameters: Optional[Dict[str, str]] = None,
        on_success: Optional[Union[str, "_models.OnSuccess"]] = None,
        on_failure: Optional[Union[str, "_models.OnFailure"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StorageTaskPreviewAction(_Model):
    """Storage Task Preview Action.

    :ivar properties: Properties of the storage task preview. Required.
    :vartype properties: ~azure.mgmt.storageactions.models.StorageTaskPreviewActionProperties
    """

    properties: "_models.StorageTaskPreviewActionProperties" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties of the storage task preview. Required."""

    @overload
    def __init__(
        self,
        *,
        properties: "_models.StorageTaskPreviewActionProperties",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StorageTaskPreviewActionCondition(_Model):
    """Represents the storage task conditions to be tested for a match with container and blob
    properties.

    :ivar if_property: The condition to be tested for a match with container and blob properties.
     Required.
    :vartype if_property: ~azure.mgmt.storageactions.models.StorageTaskPreviewActionIfCondition
    :ivar else_block_exists: Specify whether the else block is present in the condition. Required.
    :vartype else_block_exists: bool
    """

    if_property: "_models.StorageTaskPreviewActionIfCondition" = rest_field(
        name="if", visibility=["read", "create", "update", "delete", "query"]
    )
    """The condition to be tested for a match with container and blob properties. Required."""
    else_block_exists: bool = rest_field(
        name="elseBlockExists", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specify whether the else block is present in the condition. Required."""

    @overload
    def __init__(
        self,
        *,
        if_property: "_models.StorageTaskPreviewActionIfCondition",
        else_block_exists: bool,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StorageTaskPreviewActionIfCondition(_Model):
    """Represents storage task preview action condition.

    :ivar condition: Storage task condition to bes tested for a match.
    :vartype condition: str
    """

    condition: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Storage task condition to bes tested for a match."""

    @overload
    def __init__(
        self,
        *,
        condition: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StorageTaskPreviewActionProperties(_Model):
    """Storage task preview action properties.

    :ivar container: Properties of a sample container to test for a match with the preview action.
     Required.
    :vartype container: ~azure.mgmt.storageactions.models.StorageTaskPreviewContainerProperties
    :ivar blobs: Properties of some sample blobs in the container to test for matches with the
     preview action. Required.
    :vartype blobs: list[~azure.mgmt.storageactions.models.StorageTaskPreviewBlobProperties]
    :ivar action: Preview action to test. Required.
    :vartype action: ~azure.mgmt.storageactions.models.StorageTaskPreviewActionCondition
    """

    container: "_models.StorageTaskPreviewContainerProperties" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties of a sample container to test for a match with the preview action. Required."""
    blobs: List["_models.StorageTaskPreviewBlobProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties of some sample blobs in the container to test for matches with the preview action.
     Required."""
    action: "_models.StorageTaskPreviewActionCondition" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Preview action to test. Required."""

    @overload
    def __init__(
        self,
        *,
        container: "_models.StorageTaskPreviewContainerProperties",
        blobs: List["_models.StorageTaskPreviewBlobProperties"],
        action: "_models.StorageTaskPreviewActionCondition",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StorageTaskPreviewBlobProperties(_Model):
    """Storage task preview container properties.

    :ivar name: Name of test blob.
    :vartype name: str
    :ivar properties: properties key value pairs to be tested for a match against the provided
     condition.
    :vartype properties:
     list[~azure.mgmt.storageactions.models.StorageTaskPreviewKeyValueProperties]
    :ivar metadata: metadata key value pairs to be tested for a match against the provided
     condition.
    :vartype metadata: list[~azure.mgmt.storageactions.models.StorageTaskPreviewKeyValueProperties]
    :ivar tags: tags key value pairs to be tested for a match against the provided condition.
    :vartype tags: list[~azure.mgmt.storageactions.models.StorageTaskPreviewKeyValueProperties]
    :ivar matched_block: Represents the condition block name that matched blob properties. Known
     values are: "If", "Else", and "None".
    :vartype matched_block: str or ~azure.mgmt.storageactions.models.MatchedBlockName
    """

    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of test blob."""
    properties: Optional[List["_models.StorageTaskPreviewKeyValueProperties"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """properties key value pairs to be tested for a match against the provided condition."""
    metadata: Optional[List["_models.StorageTaskPreviewKeyValueProperties"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """metadata key value pairs to be tested for a match against the provided condition."""
    tags: Optional[List["_models.StorageTaskPreviewKeyValueProperties"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """tags key value pairs to be tested for a match against the provided condition."""
    matched_block: Optional[Union[str, "_models.MatchedBlockName"]] = rest_field(
        name="matchedBlock", visibility=["read"]
    )
    """Represents the condition block name that matched blob properties. Known values are: \"If\",
     \"Else\", and \"None\"."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        properties: Optional[List["_models.StorageTaskPreviewKeyValueProperties"]] = None,
        metadata: Optional[List["_models.StorageTaskPreviewKeyValueProperties"]] = None,
        tags: Optional[List["_models.StorageTaskPreviewKeyValueProperties"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StorageTaskPreviewContainerProperties(_Model):
    """Storage task preview container properties.

    :ivar name: Name of test container.
    :vartype name: str
    :ivar metadata: metadata key value pairs to be tested for a match against the provided
     condition.
    :vartype metadata: list[~azure.mgmt.storageactions.models.StorageTaskPreviewKeyValueProperties]
    """

    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of test container."""
    metadata: Optional[List["_models.StorageTaskPreviewKeyValueProperties"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """metadata key value pairs to be tested for a match against the provided condition."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        metadata: Optional[List["_models.StorageTaskPreviewKeyValueProperties"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StorageTaskPreviewKeyValueProperties(_Model):
    """Storage task preview object key value pair properties.

    :ivar key: Represents the key property of the pair.
    :vartype key: str
    :ivar value: Represents the value property of the pair.
    :vartype value: str
    """

    key: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Represents the key property of the pair."""
    value: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Represents the value property of the pair."""

    @overload
    def __init__(
        self,
        *,
        key: Optional[str] = None,
        value: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StorageTaskProperties(_Model):
    """Properties of the storage task.

    :ivar task_version: Storage task version.
    :vartype task_version: int
    :ivar enabled: Storage Task is enabled when set to true and disabled when set to false.
     Required.
    :vartype enabled: bool
    :ivar description: Text that describes the purpose of the storage task. Required.
    :vartype description: str
    :ivar action: The storage task action that is executed. Required.
    :vartype action: ~azure.mgmt.storageactions.models.StorageTaskAction
    :ivar provisioning_state: Represents the provisioning state of the storage task. Known values
     are: "ValidateSubscriptionQuotaBegin", "ValidateSubscriptionQuotaEnd", "Accepted", "Creating",
     "Succeeded", "Deleting", "Canceled", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.storageactions.models.ProvisioningState
    :ivar creation_time_in_utc: The creation date and time of the storage task in UTC.
    :vartype creation_time_in_utc: ~datetime.datetime
    """

    task_version: Optional[int] = rest_field(name="taskVersion", visibility=["read"])
    """Storage task version."""
    enabled: bool = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Storage Task is enabled when set to true and disabled when set to false. Required."""
    description: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Text that describes the purpose of the storage task. Required."""
    action: "_models.StorageTaskAction" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The storage task action that is executed. Required."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Represents the provisioning state of the storage task. Known values are:
     \"ValidateSubscriptionQuotaBegin\", \"ValidateSubscriptionQuotaEnd\", \"Accepted\",
     \"Creating\", \"Succeeded\", \"Deleting\", \"Canceled\", and \"Failed\"."""
    creation_time_in_utc: Optional[datetime.datetime] = rest_field(
        name="creationTimeInUtc", visibility=["read"], format="rfc3339"
    )
    """The creation date and time of the storage task in UTC."""

    @overload
    def __init__(
        self,
        *,
        enabled: bool,
        description: str,
        action: "_models.StorageTaskAction",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StorageTaskReportInstance(ProxyResource):
    """Storage Tasks run report instance.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.storageactions.models.SystemData
    :ivar properties: Storage task execution report for a run instance.
    :vartype properties: ~azure.mgmt.storageactions.models.StorageTaskReportProperties
    """

    properties: Optional["_models.StorageTaskReportProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Storage task execution report for a run instance."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.StorageTaskReportProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StorageTaskReportProperties(_Model):
    """Storage task execution report for a run instance.

    :ivar task_assignment_id: Resource ID of the Storage Task Assignment associated with this
     reported run.
    :vartype task_assignment_id: str
    :ivar storage_account_id: Resource ID of the Storage Account where this reported run executed.
    :vartype storage_account_id: str
    :ivar start_time: Start time of the run instance. Filter options such as startTime gt
     '2023-06-26T20:51:24.4494016Z' and other comparison operators can be used as described for
     DateTime properties in
     `https://learn.microsoft.com/en-us/rest/api/storageservices/querying-tables-and-entities#supported-comparison-operators
     <https://learn.microsoft.com/en-us/rest/api/storageservices/querying-tables-and-entities#supported-comparison-operators>`_.
    :vartype start_time: str
    :ivar finish_time: End time of the run instance. Filter options such as startTime gt
     '2023-06-26T20:51:24.4494016Z' and other comparison operators can be used as described for
     DateTime properties in
     `https://learn.microsoft.com/en-us/rest/api/storageservices/querying-tables-and-entities#supported-comparison-operators
     <https://learn.microsoft.com/en-us/rest/api/storageservices/querying-tables-and-entities#supported-comparison-operators>`_.
    :vartype finish_time: str
    :ivar objects_targeted_count: Total number of objects that meet the condition as defined in the
     storage task assignment execution context. Filter options such as objectsTargetedCount gt 50
     and other comparison operators can be used as described for Numerical properties in
     `https://learn.microsoft.com/en-us/rest/api/storageservices/querying-tables-and-entities#supported-comparison-operators
     <https://learn.microsoft.com/en-us/rest/api/storageservices/querying-tables-and-entities#supported-comparison-operators>`_.
    :vartype objects_targeted_count: str
    :ivar objects_operated_on_count: Total number of objects that meet the storage tasks condition
     and were operated upon. Filter options such as objectsOperatedOnCount ge 100 and other
     comparison operators can be used as described for Numerical properties in
     `https://learn.microsoft.com/en-us/rest/api/storageservices/querying-tables-and-entities#supported-comparison-operators
     <https://learn.microsoft.com/en-us/rest/api/storageservices/querying-tables-and-entities#supported-comparison-operators>`_.
    :vartype objects_operated_on_count: str
    :ivar object_failed_count: Total number of objects where task operation failed when was
     attempted. Filter options such as objectFailedCount eq 0 and other comparison operators can be
     used as described for Numerical properties in
     `https://learn.microsoft.com/en-us/rest/api/storageservices/querying-tables-and-entities#supported-comparison-operators
     <https://learn.microsoft.com/en-us/rest/api/storageservices/querying-tables-and-entities#supported-comparison-operators>`_.
    :vartype object_failed_count: str
    :ivar objects_succeeded_count: Total number of objects where task operation succeeded when was
     attempted.Filter options such as objectsSucceededCount gt 150 and other comparison operators
     can be used as described for Numerical properties in
     `https://learn.microsoft.com/en-us/rest/api/storageservices/querying-tables-and-entities#supported-comparison-operators
     <https://learn.microsoft.com/en-us/rest/api/storageservices/querying-tables-and-entities#supported-comparison-operators>`_.
    :vartype objects_succeeded_count: str
    :ivar run_status_error: Well known Azure Storage error code that represents the error
     encountered during execution of the run instance.
    :vartype run_status_error: str
    :ivar run_status_enum: Represents the status of the execution. Known values are: "InProgress"
     and "Finished".
    :vartype run_status_enum: str or ~azure.mgmt.storageactions.models.RunStatusEnum
    :ivar summary_report_path: Full path to the verbose report stored in the reporting container as
     specified in the assignment execution context for the storage account.
    :vartype summary_report_path: str
    :ivar task_id: Resource ID of the Storage Task applied during this run.
    :vartype task_id: str
    :ivar task_version: Storage Task Version.
    :vartype task_version: str
    :ivar run_result: Represents the overall result of the execution for the run instance. Known
     values are: "Succeeded" and "Failed".
    :vartype run_result: str or ~azure.mgmt.storageactions.models.RunResult
    """

    task_assignment_id: Optional[str] = rest_field(name="taskAssignmentId", visibility=["read"])
    """Resource ID of the Storage Task Assignment associated with this reported run."""
    storage_account_id: Optional[str] = rest_field(name="storageAccountId", visibility=["read"])
    """Resource ID of the Storage Account where this reported run executed."""
    start_time: Optional[str] = rest_field(name="startTime", visibility=["read"])
    """Start time of the run instance. Filter options such as startTime gt
     '2023-06-26T20:51:24.4494016Z' and other comparison operators can be used as described for
     DateTime properties in
     `https://learn.microsoft.com/en-us/rest/api/storageservices/querying-tables-and-entities#supported-comparison-operators
     <https://learn.microsoft.com/en-us/rest/api/storageservices/querying-tables-and-entities#supported-comparison-operators>`_."""
    finish_time: Optional[str] = rest_field(name="finishTime", visibility=["read"])
    """End time of the run instance. Filter options such as startTime gt
     '2023-06-26T20:51:24.4494016Z' and other comparison operators can be used as described for
     DateTime properties in
     `https://learn.microsoft.com/en-us/rest/api/storageservices/querying-tables-and-entities#supported-comparison-operators
     <https://learn.microsoft.com/en-us/rest/api/storageservices/querying-tables-and-entities#supported-comparison-operators>`_."""
    objects_targeted_count: Optional[str] = rest_field(name="objectsTargetedCount", visibility=["read"])
    """Total number of objects that meet the condition as defined in the storage task assignment
     execution context. Filter options such as objectsTargetedCount gt 50 and other comparison
     operators can be used as described for Numerical properties in
     `https://learn.microsoft.com/en-us/rest/api/storageservices/querying-tables-and-entities#supported-comparison-operators
     <https://learn.microsoft.com/en-us/rest/api/storageservices/querying-tables-and-entities#supported-comparison-operators>`_."""
    objects_operated_on_count: Optional[str] = rest_field(name="objectsOperatedOnCount", visibility=["read"])
    """Total number of objects that meet the storage tasks condition and were operated upon. Filter
     options such as objectsOperatedOnCount ge 100 and other comparison operators can be used as
     described for Numerical properties in
     `https://learn.microsoft.com/en-us/rest/api/storageservices/querying-tables-and-entities#supported-comparison-operators
     <https://learn.microsoft.com/en-us/rest/api/storageservices/querying-tables-and-entities#supported-comparison-operators>`_."""
    object_failed_count: Optional[str] = rest_field(name="objectFailedCount", visibility=["read"])
    """Total number of objects where task operation failed when was attempted. Filter options such as
     objectFailedCount eq 0 and other comparison operators can be used as described for Numerical
     properties in
     `https://learn.microsoft.com/en-us/rest/api/storageservices/querying-tables-and-entities#supported-comparison-operators
     <https://learn.microsoft.com/en-us/rest/api/storageservices/querying-tables-and-entities#supported-comparison-operators>`_."""
    objects_succeeded_count: Optional[str] = rest_field(name="objectsSucceededCount", visibility=["read"])
    """Total number of objects where task operation succeeded when was attempted.Filter options such
     as objectsSucceededCount gt 150 and other comparison operators can be used as described for
     Numerical properties in
     `https://learn.microsoft.com/en-us/rest/api/storageservices/querying-tables-and-entities#supported-comparison-operators
     <https://learn.microsoft.com/en-us/rest/api/storageservices/querying-tables-and-entities#supported-comparison-operators>`_."""
    run_status_error: Optional[str] = rest_field(name="runStatusError", visibility=["read"])
    """Well known Azure Storage error code that represents the error encountered during execution of
     the run instance."""
    run_status_enum: Optional[Union[str, "_models.RunStatusEnum"]] = rest_field(
        name="runStatusEnum", visibility=["read"]
    )
    """Represents the status of the execution. Known values are: \"InProgress\" and \"Finished\"."""
    summary_report_path: Optional[str] = rest_field(name="summaryReportPath", visibility=["read"])
    """Full path to the verbose report stored in the reporting container as specified in the
     assignment execution context for the storage account."""
    task_id: Optional[str] = rest_field(name="taskId", visibility=["read"])
    """Resource ID of the Storage Task applied during this run."""
    task_version: Optional[str] = rest_field(name="taskVersion", visibility=["read"])
    """Storage Task Version."""
    run_result: Optional[Union[str, "_models.RunResult"]] = rest_field(name="runResult", visibility=["read"])
    """Represents the overall result of the execution for the run instance. Known values are:
     \"Succeeded\" and \"Failed\"."""


class StorageTaskUpdateParameters(_Model):
    """Parameters of the storage task update request.

    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.storageactions.models.ManagedServiceIdentity
    :ivar tags: Gets or sets a list of key value pairs that describe the resource. These tags can
     be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags
     can be provided for a resource. Each tag must have a key no greater in length than 128
     characters and a value no greater in length than 256 characters.
    :vartype tags: dict[str, str]
    :ivar properties: Properties of the storage task.
    :vartype properties: ~azure.mgmt.storageactions.models.StorageTaskUpdateProperties
    """

    identity: Optional["_models.ManagedServiceIdentity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity of the resource."""
    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets a list of key value pairs that describe the resource. These tags can be used in
     viewing and grouping this resource (across resource groups). A maximum of 15 tags can be
     provided for a resource. Each tag must have a key no greater in length than 128 characters and
     a value no greater in length than 256 characters."""
    properties: Optional["_models.StorageTaskUpdateProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties of the storage task."""

    @overload
    def __init__(
        self,
        *,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.StorageTaskUpdateProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StorageTaskUpdateProperties(_Model):
    """Properties of the storage task.

    :ivar task_version: Storage task version.
    :vartype task_version: int
    :ivar enabled: Storage Task is enabled when set to true and disabled when set to false.
    :vartype enabled: bool
    :ivar description: Text that describes the purpose of the storage task.
    :vartype description: str
    :ivar action: The storage task action that is executed.
    :vartype action: ~azure.mgmt.storageactions.models.StorageTaskAction
    :ivar provisioning_state: Represents the provisioning state of the storage task. Known values
     are: "ValidateSubscriptionQuotaBegin", "ValidateSubscriptionQuotaEnd", "Accepted", "Creating",
     "Succeeded", "Deleting", "Canceled", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.storageactions.models.ProvisioningState
    :ivar creation_time_in_utc: The creation date and time of the storage task in UTC.
    :vartype creation_time_in_utc: ~datetime.datetime
    """

    task_version: Optional[int] = rest_field(name="taskVersion", visibility=["read"])
    """Storage task version."""
    enabled: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Storage Task is enabled when set to true and disabled when set to false."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Text that describes the purpose of the storage task."""
    action: Optional["_models.StorageTaskAction"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The storage task action that is executed."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Represents the provisioning state of the storage task. Known values are:
     \"ValidateSubscriptionQuotaBegin\", \"ValidateSubscriptionQuotaEnd\", \"Accepted\",
     \"Creating\", \"Succeeded\", \"Deleting\", \"Canceled\", and \"Failed\"."""
    creation_time_in_utc: Optional[datetime.datetime] = rest_field(
        name="creationTimeInUtc", visibility=["read"], format="rfc3339"
    )
    """The creation date and time of the storage task in UTC."""

    @overload
    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        description: Optional[str] = None,
        action: Optional["_models.StorageTaskAction"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SystemData(_Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.storageactions.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.storageactions.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_by: Optional[str] = rest_field(name="createdBy", visibility=["read", "create", "update", "delete", "query"])
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="createdByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.datetime] = rest_field(
        name="createdAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource creation (UTC)."""
    last_modified_by: Optional[str] = rest_field(
        name="lastModifiedBy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="lastModifiedByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.datetime] = rest_field(
        name="lastModifiedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource last modification (UTC)."""

    @overload
    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UserAssignedIdentity(_Model):
    """User assigned identity properties.

    :ivar principal_id: The principal ID of the assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the assigned identity.
    :vartype client_id: str
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The principal ID of the assigned identity."""
    client_id: Optional[str] = rest_field(name="clientId", visibility=["read"])
    """The client ID of the assigned identity."""
