/*
 * Copyright (C) 2022 Apple Inc. All rights reserved.
 * Copyright (C) 2023 Igalia S.L
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

#if ENABLE(WEB_CODECS)

#include "AacEncoderConfig.h"
#include "BitrateMode.h"
#include "FlacEncoderConfig.h"
#include "OpusEncoderConfig.h"
#include <optional>
#include <wtf/text/WTFString.h>

namespace WebCore {

struct WebCodecsAudioEncoderConfig {
    String codec;
    size_t sampleRate;
    size_t numberOfChannels;
    std::optional<uint64_t> bitrate;
    BitrateMode bitrateMode { BitrateMode::Variable };
    std::optional<OpusEncoderConfig> opus;
    std::optional<AacEncoderConfig> aac;
    std::optional<FlacEncoderConfig> flac;

    WebCodecsAudioEncoderConfig isolatedCopy() && { return { WTF::move(codec).isolatedCopy(), sampleRate, numberOfChannels, bitrate, bitrateMode, opus, aac, flac }; }
    WebCodecsAudioEncoderConfig isolatedCopy() const & { return { codec.isolatedCopy(), sampleRate, numberOfChannels, bitrate, bitrateMode, opus, aac, flac }; }
};

}

#endif // ENABLE(WEB_CODECS)
